--[[
  Steghide storage for darktable 

  copyright (c) 2016, 2017  Holger Klemm
  
  darktable is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  darktable is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with darktable.  If not, see <http://www.gnu.org/licenses/>.
]]

--[[
Version 2.1.1


ADDITIONAL SOFTWARE NEEDED FOR THIS SCRIPT
* steghide

USAGE
* require this file from your main luarc config file.

Release note:
- fix compatibility with other scripts
- code rewritten
- add import to database option   
   
This plugin will add a new storage option and calls hugin after export.
]]

local dt = require "darktable"
local gettext = dt.gettext

-- works only with darktable API version 4.0.0
dt.configuration.check_version(...,{4,0,0})

-- Tell gettext where to find the .mo file translating messages for a particular domain
gettext.bindtextdomain("steghideexport",dt.configuration.config_dir.."/lua/")

local function _(msgid)
    return gettext.dgettext("steghideexport", msgid)
end


steghideexport_numberofimages=0
steghideexport_homepath=os.getenv("HOME")
steghideexport_tmppath=steghideexport_homepath.."/.local/tmp"

steghideexport_check_button_selected_file = dt.new_widget("check_button")
{
    label = _('use selected text file'), 
    value = true,
    tooltip =_('default text file: ~/.config/darktable/steghide/steghide_default'),   
    reset_callback = function(self_export) 
       self_export.value = true 
    end
    
}


steghideexport_check_button_usertext = dt.new_widget("check_button")
{
    label = _('use user text line'), 
    value = false,
    tooltip =_('umbed the user text line'),  
    reset_callback = function(self_export2) 
       self_export2.value = false 
    end
    
}


local steghideexport_label_password = dt.new_widget("label")
{
      label = _('password:'),
      ellipsize = "start",
      halign = "start",
      tooltip = _('steghide requires a password')
}

steghideexport_entrypassword = dt.new_widget("entry")
{
    text = "", 
    placeholder = _('please enter a password'),
    is_password = false,
    editable = true,
    tooltip = _('enter a password'),
    reset_callback = function(self_export3) 
       self_export3.text = "" 
    end
}


local steghideexport_label_usertext= dt.new_widget("label")
{
     label = _('user text line:'),
     ellipsize = "start",
     halign = "start"
}


steghideexport_entrytext = dt.new_widget("entry")
{
    text = "", 
    sensitive = true,
    is_password = true,
    editable = true,
    tooltip = _('enter the user text to embed'),
    reset_callback = function(self_export4) 
       self_export4.text = "" 
    end

}


local steghideexport_label_path = dt.new_widget("label")
{
     label = _('target directory:'),
     ellipsize = "start",
     halign = "start"
}

local steghideexport_label_textfile= dt.new_widget("label")
{
     label = _('selected text file:'),
     ellipsize = "start",
     halign = "start"
}

local steghideexport_label_enc= dt.new_widget("label")
{
     label = _('encryption algorithm / mode:'),
     ellipsize = "start",
     halign = "start"
}


-- Target directory dialog
steghideexport_file_chooser_button = dt.new_widget("file_chooser_button")
{
    title = _('export Steghide JPEG'),  -- The title of the window when choosing a file
    is_directory = true             -- True if the file chooser button only allows directories to be selecte
}


-- Text file dialog
steghideexport_textsteghideexport_file_chooser_button = dt.new_widget("file_chooser_button")
{
    title = _('text file'),  -- The title of the window when choosing a file
    value = ".config/darktable/steghide/steghide_default",
    reset_callback = function(self_export5) 
       self_export5.value = ".config/darktable/steghide/steghide_default" 
    end
}


local selection = dt.gui.selection()
  local result = ""
  local array = {}
  for _,img in pairs(selection) do
    array[img.path] = true
  end
  for path in pairs(array) do
    if result == "" then
      result = path
    else
      result = result.."\n"..path
    end
end


steghideexport_enc_combobox = dt.new_widget("combobox")
{
    label = "", 
    value = 15, "cast-128 cbc", "cast-128 cfb", "cast-128 ctr","cast-128 ecb","cast-128 ncfb","cast-128 nofb","cast-128 ofb","gost cbc","gost cfb","gost ctr","gost ecb","gost ncfb","gost nofb","gost ofb","rijndael-128 cbc","rijndael-128 cfb","rijndael-128 ctr","rijndael-128 ecb","rijndael-128 ncfb","rijndael-128 nofb","rijndael-128 ofb","twofish cbc","twofish cfb","twofish ctr","twofish ecb","twofish ncfb","twofish nofb","twofish ofb","arcfour stream","cast-256 cbc","cast-256 cfb","cast-256 ctr","cast-256 ecb","cast-256 ncfb","cast-256 nofb","cast-256 ofb","loki97 cbc","loki97 cfb","loki97 ctr","loki97 ecb","loki97 ncfb","loki97 nofb","loki97 ofb","rijndael-192 cbc","rijndael-192 cfb","rijndael-192 ctr","rijndael-192 ecb","rijndael-192 ncfb","rijndael-192 nofb","rijndael-192 ofb","saferplus cbc","saferplus cfb","saferplus ctr","saferplus ecb","saferplus ncfb","saferplus nofb","saferplus ofb","wake stream","des cbc","des cfb","des ctr","des ecb","des ncfb","des nofb","des ofb","rijndael-256 cbc","rijndael-256 cfb","rijndael-256 ctr","rijndael-256 ecb","rijndael-256 ncfb","rijndael-256 nofb","rijndael-256 ofb","serpent cbc","serpent cfb","serpent ctr","serpent ecb","serpent ncfb","serpent nofb","serpent ofb","xtea cbc","xtea cfb","xtea ctr","xtea ecb","xtea ncfb","xtea nofb","xtea ofb","blowfish cbc","blowfish cfb","blowfish ctr","blowfish ecb","blowfish ncfb","blowfish nofb","blowfish ofb","enigma stream","rc2 cbc","rc2 cfb","rc2 ctr","rc2 ecb","rc2 ncfb","rc2 nofb","rc2 ofb","tripledes cbc","tripledes cfb","tripledes ctr","tripledes ecb","tripledes ncfb","tripledes nofb","tripledes ofb",
    reset_callback = function(self_export6) 
       self_export6.value = 15 
    end
}  
  
  
local widget = dt.new_widget("box") {
    orientation = "vertical",
    steghideexport_check_button_selected_file,
    steghideexport_check_button_usertext,
    steghideexport_label_textfile,
    steghideexport_textsteghideexport_file_chooser_button,
    steghideexport_label_usertext,
    steghideexport_entrytext,
    steghideexport_label_password,
    steghideexport_entrypassword,
    steghideexport_label_enc,
    steghideexport_enc_combobox,
    steghideexport_label_path,
    steghideexport_file_chooser_button,    
}

local function GetFileName(full_path)
      local filename_with_suffix=full_path:match("[^/]+$" )
      return filename_with_suffix
end

local function checkIfBinExists(bin)
  local handle = io.popen("which "..bin)
  local result = handle:read()
  local ret
  handle:close()
  if (result) then
 --   dt.print_error("true checkIfBinExists: "..bin)
    ret = true
  else
    dt.print_error(bin.." not found")
    ret = false
  end


  return ret
end



local function show_status(storage, image, format, filename,
  number, total, high_quality, extra_data)
  if (not (steghideexport_entrypassword.text == "")) then
  dt.print(_('export JPEG to Steghide ')..tostring(number).."/"..tostring(total))
  numberofimages=total
  else
  dt.print(_('ERROR: no password found'))    
  end    
end














local function create_steghidefoto(storage, image_table, extra_data) --finalize
  if (checkIfBinExists("steghide")) then
  job = dt.gui.create_job(_('creating steghide JPEG image'), true, stop_selection)
  job.percent = 0.1  
--check input and create text file
    if (
        (steghideexport_entrypassword.text ~= "") and 
        (steghideexport_check_button_selected_file.value) and  
        (steghideexport_textsteghideexport_file_chooser_button.value ~= nil) and
        (steghideexport_file_chooser_button.value ~=nil) and
        (steghideexport_check_button_usertext.value) and 
        (steghideexport_entrytext.text ~= "")
        ) then
        dt.print(_('creating text file'))   
        textline = steghideexport_entrytext.text
        default_file = io.open(steghideexport_textsteghideexport_file_chooser_button.value,"r")
        defaulttext = default_file:read("*a")
        combinetext = defaulttext.."\n\n"..textline
        combine_file = io.open(steghideexport_tmppath.."/steghide_combine", "w")
        combine_file:write(combinetext)
        io.close(combine_file)
        textfile = steghideexport_tmppath.."/steghide_combine"  
    elseif (
        (steghideexport_entrypassword.text ~= "") and 
        (steghideexport_check_button_selected_file.value) and 
        (steghideexport_textsteghideexport_file_chooser_button.value ~= nil) and 
        (steghideexport_file_chooser_button.value ~=nil) and
        (steghideexport_check_button_usertext.value == false) 
        ) then
    dt.print(_('creating text file'))
        textfile = steghideexport_textsteghideexport_file_chooser_button.value
    
    elseif (
        (steghideexport_entrypassword.text ~= "") and 
        (steghideexport_check_button_usertext.value) and 
        (steghideexport_entrytext.text ~= "") and 
        (steghideexport_file_chooser_button.value ~=nil)
        ) then
    dt.print(_('creating text file'))
        textline_file = io.open(steghideexport_tmppath.."/steghide_text_line", "w")
        textline_file:write(steghideexport_entrytext.text)
        io.close(textline_file)
        textfile = steghideexport_tmppath.."/steghide_text_line"

--ERROR messages        
    elseif (steghideexport_entrypassword.text == "") then   
      dt.print(_('ERROR: no password found'))
      job.valid = false
      return
    elseif ((steghideexport_check_button_selected_file.value == false) and (steghideexport_check_button_usertext.value == false)) then
      dt.print(_('ERROR: no text file selected'))
      job.valid = false
      return
    elseif ((steghideexport_check_button_usertext.value) and (steghideexport_entrytext.text == "")) then  
      dt.print(_('ERROR: no user text found'))
      job.valid = false
      return
    elseif (steghideexport_file_chooser_button.value ==nil) then
      dt.print(_('ERROR: no target directory selected'))
      job.valid = false
      return
    end
job.percent = 0.2      
--create steghide command    
    local steghideStartCommand
    img_path = steghideexport_file_chooser_button.value 
    encmode = steghideexport_enc_combobox.value
    steghidepassword = steghideexport_entrypassword.text
    dt.print(_('embeding text...'))
        for _,v in pairs(image_table) do
        steghideStartCommand = "steghide --embed --encryption " ..encmode.. " --nochecksum -q -p " ..steghidepassword.. " -cf \""..v.."\" -ef \""..textfile.."\"" 
        resultsteghide=dt.control.execute(steghideStartCommand)
           if (resultsteghide ==0) then
             moveFileCommand = "mv \""..v.."\" \""..img_path.."\""
             resultmove=dt.control.execute(moveFileCommand)
             if ((resultmove == 0) and (dt.preferences.read("module_steghide", "add_image_to_db", "bool"))) then
                  local jpeg_filename=GetFileName(v)
                  local steghide_path_with_filename=img_path.."/"..jpeg_filename
                  local image = dt.database.import(steghide_path_with_filename)
             end  
          else     
             dt.print(_('ERROR: steghide doesn\'t work. for more informations see terminal output'))
             dt.control.execute("rm "..steghideexport_tmppath.."/*.jpg")
             job.valid = false
             return
          end    
        end
        dt.print(_('process successfully completed'))
        job.valid = false
 
    
  else
    dt.print(_('ERROR: steghide not found. please install steghide.'))
    dt.print_error(_('steghide not found. please install steghide.'))
    return
  end
end




-- limit export to jpeg (8 bit)
local function support_format(storage, format)
  fmt = string.lower(format.name)
  if string.match(fmt,"jpeg%s%g8%sbit%g") == nil then
    return false
  else
    return true
  end   
end  



-- Register
dt.register_storage("module_steghide", _('steghide JPEG image'), show_status, create_steghidefoto, support_format, nil, widget)

dt.preferences.register("module_steghide",        
                        "add_image_to_db",                                        -- name
                        "bool",                                                   -- type
                        _('steghide export: add steghide image to database'),     -- label
                        _('add the steghide image to the darktable database'),    -- tooltip
                        false)                                                    -- d