--[[
  Enfuse professional plugin for darktable 2.2.X and 2.3.X

  copyright (c) 2017  Holger Klemm
  
  darktable is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  darktable is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with darktable.  If not, see <http://www.gnu.org/licenses/>.
]]

--[[
Version 2.1.3 for darktable 2.2.X

Known bugs:   

Release note:
- fix compatibility with other scripts
   
   
ADDITIONAL SOFTWARE NEEDED FOR THIS SCRIPT
* align_image_stack
* enfuse
* exiftool

USAGE
* require this file from your main luarc config file.

This plugin will add the new export modul "fusion to HDR or DFF image".
]]

local dt = require "darktable"
local gettext = dt.gettext

-- work with LUA API version 4.0.0 and 5.0.0
dt.configuration.check_version(...,{4,0,0},{5,0,0})

-- Tell gettext where to find the .mo file translating messages for a particular domain
gettext.bindtextdomain("enfuse_pro",dt.configuration.config_dir.."/lua/")

local function _(msgid)
    return gettext.dgettext("enfuse_pro", msgid)
end


-- command variables
-- align
enfuse_pro_cmd_align_radial_distortion=""
enfuse_pro_cmd_align_optimize_field=""            
enfuse_pro_cmd_align_optimize_center=""          
enfuse_pro_cmd_align_auto_crop=""  
enfuse_pro_cmd_align_distortion=""
enfuse_pro_cmd_align_grid_size=""
enfuse_pro_cmd_align_control_points=""  
enfuse_pro_cmd_align_control_points_remove=""
enfuse_pro_cmd_align_correlation=""   
enfuse_pro_cmd_align_use_gpu=""
-- enfuse
enfuse_pro_cmd_enfuse_exposure_weight=""                
enfuse_pro_cmd_enfuse_saturation_weight=""                
enfuse_pro_cmd_enfuse_contrast_weight=""
enfuse_pro_cmd_enfuse_exposure_optimum_weight="" 
enfuse_pro_cmd_enfuse_exposure_width_weight=""
enfuse_pro_cmd_enfuse_hard_masks=""
enfuse_pro_cmd_enfuse_save_masks=""
enfuse_pro_cmd_enfuse_contrast_window_size=""
enfuse_pro_cmd_enfuse_contrast_edge_scale=""
enfuse_pro_cmd_enfuse_contrast_min_curvature=""

enfuse_pro_cmd_enfuse_color_depth=""
enfuse_pro_cmd_enfuse_compression=""

enfuse_pro_first_imagefile=""
enfuse_pro_last_imagefile=""
enfuse_pro_cmd_tmp_path=""
enfuse_pro_cmd_output_path=""
enfuse_pro_cmd_output_image=""
enfuse_pro_cmd_output_image_index=0
enfuse_pro_path_with_filename=""
enfuse_pro_homepath=os.getenv("HOME")
enfuse_pro_tmppath=enfuse_pro_homepath.."/.local/tmp"
-- exif
enfuse_pro_cmd_exif_copy_exif=""
-- output
enfuse_pro_cmd_suffix_output_format=""
-- commands
enfuse_pro_alignStartCommand=""
enfuse_pro_enfuseStartCommand=""
enfuse_pro_exixStartCommand=""

enfuse_pro_outputindex=0
enfuse_pro_job=0
-- initialize combobox and checkbox value for default
if (dt.preferences.read("enfuse_pro",  "selected_fusion", "integer") == 0) or (dt.preferences.read("enfuse_pro",  "selected_overwrite", "integer") == 0) then
    -- align defaults
   dt.preferences.write("enfuse_pro", "selected_fusion", "integer", 1)           --Typ HDR
   dt.preferences.write("enfuse_pro", "checked_radial_distortion", "bool", false)      
   dt.preferences.write("enfuse_pro", "checked_optimize_field", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_optimize_image_center", "bool", true) 
   dt.preferences.write("enfuse_pro", "checked_auto_crop", "bool", true) 
   dt.preferences.write("enfuse_pro", "checked_distortion", "bool", true) 
   dt.preferences.write("enfuse_pro", "selected_grid_size", "integer", 5)
   dt.preferences.write("enfuse_pro", "selected_control_points", "integer", 8)
   dt.preferences.write("enfuse_pro", "selected_control_points_remove", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_correlation", "integer", 9)
   -- enfuse defaults
   dt.preferences.write("enfuse_pro", "selected_fusion_type", "integer", 1)
   dt.preferences.write("enfuse_pro", "checked_image_variants", "bool", false)
   dt.preferences.write("enfuse_pro", "checked_hard_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_contrast_min_curvature", "integer", 1) 
   dt.preferences.write("enfuse_pro", "set_exposure_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_saturation_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_contrast_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_exposure_width_weight", "float",0.2)
   dt.preferences.write("enfuse_pro", "selected_overwrite", "integer",1)
   dt.preferences.write("enfuse_pro", "sentitiv_overwrite", "bool",true)
   
   
   -- preset HDR 1
   dt.preferences.write("enfuse_pro", "checked_hdr1_hard_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_hdr1_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_min_curvature", "integer", 1) 
   dt.preferences.write("enfuse_pro", "set_hdr1_exposure_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_hdr1_saturation_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr1_contrast_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_hdr1_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr1_exposure_width_weight", "float",0.2)
   
   -- preset HDR 2
   dt.preferences.write("enfuse_pro", "checked_hdr2_hard_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_hdr2_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_min_curvature", "integer", 1) 
   dt.preferences.write("enfuse_pro", "set_hdr2_exposure_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_hdr2_saturation_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr2_contrast_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_hdr2_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr2_exposure_width_weight", "float",0.2)
   
   -- preset HDR 3
   dt.preferences.write("enfuse_pro", "checked_hdr3_hard_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_hdr3_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_min_curvature", "integer", 1)  
   dt.preferences.write("enfuse_pro", "set_hdr3_exposure_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_hdr3_saturation_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr3_contrast_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_hdr3_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr3_exposure_width_weight", "float",0.2)
   
   -- preset DFF 1
   dt.preferences.write("enfuse_pro", "checked_dff1_hard_masks", "bool", true) 
   dt.preferences.write("enfuse_pro", "checked_dff1_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_dff1_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_dff1_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_dff1_contrast_min_curvature", "integer", 1)  
   dt.preferences.write("enfuse_pro", "set_dff1_exposure_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff1_saturation_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff1_contrast_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_dff1_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_dff1_exposure_width_weight", "float",0.2)
   
   -- preset DFF 2
   dt.preferences.write("enfuse_pro", "checked_dff2_hard_masks", "bool", true) 
   dt.preferences.write("enfuse_pro", "checked_dff2_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_dff2_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_dff2_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_dff2_contrast_min_curvature", "integer", 1)  
   dt.preferences.write("enfuse_pro", "set_dff2_exposure_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff2_saturation_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff2_contrast_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_dff2_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_dff2_exposure_width_weight", "float",0.2)
   
   -- preset DFF 3
   dt.preferences.write("enfuse_pro", "checked_dff3_hard_masks", "bool", true) 
   dt.preferences.write("enfuse_pro", "checked_dff3_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_dff3_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_dff3_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_dff3_contrast_min_curvature", "integer", 1) 
   dt.preferences.write("enfuse_pro", "set_dff3_exposure_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff3_saturation_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff3_contrast_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_dff3_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_dff3_exposure_width_weight", "float",0.2)
   
    -- preset FREE
   dt.preferences.write("enfuse_pro", "checked_free_hard_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_free_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_free_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_free_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_free_contrast_min_curvature", "integer", 1)  
   dt.preferences.write("enfuse_pro", "set_free_exposure_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_free_saturation_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_free_contrast_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_free_exposure_optimum_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_free_exposure_width_weight", "float",0.0)
   
   -- output
   dt.preferences.write("enfuse_pro", "selected_output_format", "integer", 2)
      
end


--GUI
local enfuse_pro_separator1 = dt.new_widget("separator")
{
}
local enfuse_pro_separator1b = dt.new_widget("separator")
{
}

local enfuse_pro_separator2 = dt.new_widget("separator")
{}

local enfuse_pro_separator2b = dt.new_widget("separator")
{}

local enfuse_pro_label_line1= dt.new_widget("label")
{
     label = "_______________________________________________",
     ellipsize = "start",
     halign = "end"
}

local enfuse_pro_label_line2= dt.new_widget("label")
{
     label = "_______________________________________________",
     ellipsize = "start",
     halign = "end"
}

local enfuse_pro_label_line3= dt.new_widget("label")
{
     label = "_______________________________________________",
     ellipsize = "start",
     halign = "end"
}

local enfuse_pro_label_align_options= dt.new_widget("label")
{
     label = _('image align options'),
     ellipsize = "start",
     halign = "end"
}

local enfuse_pro_label_enfuse_options= dt.new_widget("label")
{
     label = _('image fusion options'),
     ellipsize = "start",
     halign = "end"
}


local enfuse_pro_label_output_format= dt.new_widget("label")
{
     label = _('target file'),
     ellipsize = "start",
     halign = "end"
}

local enfuse_pro_label_path = dt.new_widget("label")
{
     label = _('directory'),
     ellipsize = "start",
     halign = "start"
}





enfuse_pro_check_button_radial_distortion = dt.new_widget("check_button")
{
    label = _('optimize radial distortion for all images'), 
    value = dt.preferences.read("enfuse_pro", "checked_radial_distortion", "bool"),
    tooltip =_('optimize radial distortion for all images, \nexcept for first'),   
    clicked_callback = function(distortion)   
      if (distortion.value) then
             dt.preferences.write("enfuse_pro", "checked_radial_distortion", "bool", true)
             enfuse_pro_cmd_align_radial_distortion="-d"           
          --   return
          else
             dt.preferences.write("enfuse_pro", "checked_radial_distortion", "bool", false)
             enfuse_pro_cmd_align_radial_distortion=""
         --    return
          end
    end,
}

enfuse_pro_check_button_optimize_field = dt.new_widget("check_button")
{
    label = _('optimize field of view for all images'), 
    value = dt.preferences.read("enfuse_pro", "checked_optimize_field", "bool"),
    tooltip =_('optimize field of view for all images, except for first. \nUseful for aligning focus stacks (DFF) with slightly \ndifferent magnification.'), 
    clicked_callback = function(field)   
          if (field.value) then
             dt.preferences.write("enfuse_pro", "checked_optimize_field", "bool", true)
             enfuse_pro_cmd_align_optimize_field="-m"           
          --   return
          else
             dt.preferences.write("enfuse_pro", "checked_optimize_field", "bool", false)
             enfuse_pro_cmd_align_optimize_field=""
         --    return
          end
    end,
}


enfuse_pro_check_button_optimize_image_center = dt.new_widget("check_button")
{
    label = _('optimize image center shift for all images'), 
    value = dt.preferences.read("enfuse_pro", "checked_optimize_image_center", "bool"),
    tooltip =_('optimize image center shift for all images, \nexcept for first.'),   
    clicked_callback = function(center)   
         if (center.value) then
             dt.preferences.write("enfuse_pro", "checked_optimize_image_center", "bool", true)
             enfuse_pro_cmd_align_optimize_center="-i"           
          --   return
         else
             dt.preferences.write("enfuse_pro", "checked_optimize_image_center", "bool", false)
             enfuse_pro_cmd_align_optimize_center=""
         --    return
         end  
    end,
}


enfuse_pro_check_button_auto_crop = dt.new_widget("check_button")
{
    label = _('auto crop the image'), 
    value = dt.preferences.read("enfuse_pro", "checked_auto_crop", "bool"),
    tooltip =_('auto crop the image to the area covered by all images.'),   
    clicked_callback = function(auto)   
         if (auto.value) then
             dt.preferences.write("enfuse_pro", "checked_auto_crop", "bool", true)
             enfuse_pro_cmd_align_auto_crop="-C"           
          --   return
         else
             dt.preferences.write("enfuse_pro", "checked_auto_crop", "bool", false)
             enfuse_pro_cmd_align_auto_crop=""
         --    return
         end  
    end,
}


enfuse_pro_check_button_distortion = dt.new_widget("check_button")
{
    label = _('load distortion from lens database'), 
    value = dt.preferences.read("enfuse_pro", "checked_distortion", "bool"),
    tooltip =_('try to load distortion information from lens database'),   
    clicked_callback = function(distortion)   
         if (distortion.value) then
             dt.preferences.write("enfuse_pro", "checked_distortion", "bool", true)
             enfuse_pro_cmd_align_distortion="--distortion"           
          --   return
         else
             dt.preferences.write("enfuse_pro", "checked_distortion", "bool", false)
             enfuse_pro_cmd_align_distortion=""
         --    return
         end  
    end,
}


enfuse_pro_check_button_hard_masks = dt.new_widget("check_button")
{
    label = _('hard mask'), 
    value = dt.preferences.read("enfuse_pro", "checked_hard_masks", "bool"),
    tooltip =_('force hard blend masks on the finest scale. this avoids \naveraging of fine details (only), at the expense \nof increasing the noise. this improves the \nsharpness of focus stacks considerably.\ndefault (soft mask)'),   
    reset_callback = function(self_hard_mask) 
       self_hard_mask.value = dt.preferences.read("enfuse_pro", "checked_hard_masks", "bool")
    end
    
}

enfuse_pro_check_button_save_masks = dt.new_widget("check_button")
{
    label = _('save masks'), 
    value = dt.preferences.read("enfuse_pro", "checked_save_masks", "bool"),
    tooltip =_('Save the generated weight masks to your home directory,\nenblend saves masks as 8 bit grayscale, \ni.e. single channel images. \nfor accuracy we recommend to choose a lossless format.'),  
    reset_callback = function(self_save_mask) 
       self_save_mask.value = dt.preferences.read("enfuse_pro", "checked_save_masks", "bool")
    end
    
}


enfuse_pro_slider_exposure_weight = dt.new_widget("slider")
{
  label = _('exposure weight'),
  tooltip = _('set the relative weight of the well-exposedness criterion \nas defined by the chosen exposure weight function. \nincreasing this weight relative to the others will\n make well-exposed pixels contribute more to\n the final output. \ndefault: (1.0)'),
  hard_min = 0,
  hard_max = 1,
  value = dt.preferences.read("enfuse_pro", "set_exposure_weight", "float") --1 default

}

enfuse_pro_slider_saturation_weight = dt.new_widget("slider")
{
  label = _('saturation weight'),
  tooltip = _('set the relative weight of high-saturation pixels. \nincreasing this weight makes pixels with high \nsaturation contribute more to the final output. \ndefault: (0.2)'),
  hard_min = 0,
  hard_max = 1,
  value = dt.preferences.read("enfuse_pro", "set_saturation_weight", "float"), --0.5
  
  
  
}

enfuse_pro_slider_contrast_weight = dt.new_widget("slider")
{
  label = _('contrast weight'),
  tooltip = _('sets the relative weight of high local-contrast pixels. \ndefault: (0.0).'),
  hard_min = 0,
  hard_max = 1,
  value = dt.preferences.read("enfuse_pro", "set_contrast_weight", "float")--0 default
 
}

enfuse_pro_slider_exposure_optimum_weight = dt.new_widget("slider")
{
  label = _('exposure optimum'),
  tooltip = _('determine at what normalized exposure value\n the optimum exposure of the input images\n is. this is, set the position of the maximum\n of the exposure weight curve. use this \noption to fine-tune exposure weighting. \ndefault: (0.5)'),
  hard_min = 0,
  hard_max = 1,
  value = dt.preferences.read("enfuse_pro", "set_exposure_optimum_weight", "float")--0.5 default0

}

enfuse_pro_slider_exposure_width_weight = dt.new_widget("slider")
{
  label = _('exposure width'),
  tooltip = _('set the characteristic width (FWHM) of the exposure \nweight function. low numbers give less weight to \npixels that are far from the user-defined \noptimum and vice versa. use this option to \nfine-tune exposure weighting. \ndefault: (0.2)'),
  hard_min = 0,
  hard_max = 1,
  value = dt.preferences.read("enfuse_pro", "set_exposure_width_weight", "float") --0.2 default

}




enfuse_pro_file_chooser_button_path = dt.new_widget("file_chooser_button")
{
    title = _('Select export path'),  -- The title of the window when choosing a file
    is_directory = true,             -- True if the file chooser button only allows directories to be selecte
    tooltip =_('select the target directory for the fused image. \nthe filename is created automatically.')
}



enfuse_pro_combobox_grid_size = dt.new_widget("combobox")
{
    label = _('image grid size'), 
    tooltip =_('break image into a rectangular grid \nand attempt to find num control points in each section.\ndefault: (5x5)'),
    value =  dt.preferences.read("enfuse_pro", "selected_grid_size", "integer"), 
    changed_callback = function(sel_grid_size) 
    end,
    "1", "2", "3","4","5","6","7","8","9",
    
    reset_callback = function(self_grid)
       self_grid.value = dt.preferences.read("enfuse_pro", "selected_grid_size", "integer")
    end
} 


enfuse_pro_combobox_control_points = dt.new_widget("combobox")
{
    label = _('control points/grid'), 
    tooltip =_('number of control points (per grid, see option -g) \nto create between adjacent images \ndefault: (8).'),
    value =   dt.preferences.read("enfuse_pro", "selected_control_points", "integer"),   --8, "1", "2", "3","4","5","6","7","8","9",
    changed_callback = function(sel_control_points) 
    end,
    "1", "2", "3","4","5","6","7","8","9",        
            
    reset_callback = function(self_points)
       self_points.value = dt.preferences.read("enfuse_pro", "selected_control_points", "integer")
    end
} 



enfuse_pro_combobox_control_points_remove = dt.new_widget("combobox")
{
    label = _('remove control points with error'), 
    tooltip =_('remove all control points with an error higher \nthan num pixels \ndefault: (3)'),
    value = dt.preferences.read("enfuse_pro", "selected_control_points_remove", "integer"), --3, "1", "2", "3","4","5","6","7","8","9",
    changed_callback = function(sel_control_points_remove) 
    end,
    "1", "2", "3","4","5","6","7","8","9",              
    reset_callback = function(self_points_error)
       self_points_error.value = dt.preferences.read("enfuse_pro", "selected_control_points_remove", "integer")
    end
} 



enfuse_pro_combobox_correlation  = dt.new_widget("combobox")
{
    label = _('correlation threshold for control points'), 
    tooltip =_('correlation threshold for identifying \ncontrol points \ndefault: (0.9).'),
    value = dt.preferences.read("enfuse_pro", "selected_correlation", "integer"), --9, "0,1", "0,2", "0,3","0,4","0,5","0,6","0,7","0,8","0,9",
    changed_callback = function(sel_correlation) 
    end,
    "0.1", "0.2", "0.3","0.4","0.5","0.6","0.7","0.8","0.9","1.0",  
            
            
    reset_callback = function(self_correlation)
       self_correlation.value = dt.preferences.read("enfuse_pro", "selected_correlation", "integer")
    end
} 



enfuse_pro_combobox_contrast_window_size = dt.new_widget("combobox")
{
    label = _('contrast window size'), 
    tooltip =_('set the window size for local contrast analysis. \nthe window will be a square of size × size pixels. \nif given an even size, Enfuse will \nautomatically use the next odd number.\nfor contrast analysis size values larger \nthan 5 pixels might result in a \nblurry composite image. values of 3 and \n5 pixels have given good results on \nfocus stacks. \ndefault: (5) pixels'),
    value = dt.preferences.read("enfuse_pro", "selected_contrast_window_size", "integer"), --3, "3","4","5","6","7","8","9","10",
    changed_callback = function(sel_window_size) 
    enfuse_pro_cmd_enfuse_contrast_window_size="--contrast-window-size="..sel_window_size.value
    end,
    "3", "4", "5","6","7","8","9","10",   
} 



enfuse_pro_combobox_contrast_edge_scale = dt.new_widget("combobox")
{
    label = _('contrast edge scale'), 
    tooltip =_('a non-zero value for EDGE-SCALE switches on the \nLaplacian-of-Gaussian (LoG) edge detection algorithm.\n edage-scale is the radius of the Gaussian used \nin the search for edges. a positive LCE-SCALE \nturns on local contrast enhancement (LCE) \nbefore the LoG edge detection. \nDefault: (0.0) pixels.'),
    value = dt.preferences.read("enfuse_pro", "selected_contrast_edge_scale", "integer"), --1, "0:0:0",
    changed_callback = function(sel_contrast_edge_scale) 
    enfuse_pro_cmd_enfuse_contrast_edge_scale="--contrast-edge-scale="..sel_contrast_edge_scale.value
    end,
    "0.0","0.1","0.2","0.3","0.4","0.5",

}  


enfuse_pro_combobox_contrast_min_curvature = dt.new_widget("combobox")
{
    label = _('contrast min curvature'),
    tooltip =_('define the minimum curvature for the LoG edge detection. Append a ‘%’ to specify the minimum curvature relative to maximum pixel value in the source image. Default: (0.0%)'),
    value = dt.preferences.read("enfuse_pro", "selected_contrast_min_curvature", "integer"), --1, "0.0%","0.1%", "0.2%", "0.3%","0.4%","0.5%","0.6%","0.7%","0.8%","0.9%","1.0%", 
    changed_callback = function(sel_contrast_min_curvature) 
    enfuse_pro_cmd_enfuse_contrast_min_curvature="--contrast-min-curvature="..sel_contrast_min_curvature.value
    end,
    "0.0%", "0.1%", "0.2%","0.3%","0.4%","0.5%","0.6%","0.7%","0.8%","0.9%","1.0%",   
}  

enfuse_pro_combobox_existing_file = dt.new_widget("combobox")
{
    label = _('on conflict'), 
    value = dt.preferences.read("enfuse_pro", "selected_overwrite", "integer"), --1, 
    sensitive= dt.preferences.read("enfuse_pro", "sentitiv_overwrite", "bool"), --1, 
    changed_callback = function(sel_overwrite) 
       dt.preferences.write("enfuse_pro", "selected_overwrite", "integer", sel_overwrite.selected)
    end,
    _('create unique filename'),_('overwrite'),           
    reset_callback = function(self_overwrite)
       self_overwrite.value = dt.preferences.read("enfuse_pro", "selected_overwrite", "integer")
    end
}  

enfuse_pro_check_button_image_variations = dt.new_widget("check_button")
{
    label = _('create image variants with saved presets'), 
    value = dt.preferences.read("enfuse_pro", "checked_image_variants", "bool"),
    tooltip =_('creates image variants with the three \nsaved HDR or DFF presets'),   
    sensitive=true,
    clicked_callback = function(variations) 
    if (variations.value) then
        dt.preferences.write("enfuse_pro", "checked_image_variants", "bool", true)
        dt.preferences.write("enfuse_pro", "sentitiv_overwrite", "bool",false)
        enfuse_pro_combobox_existing_file.value=1
        enfuse_pro_combobox_existing_file.sensitive=false
    else  
       dt.preferences.write("enfuse_pro", "checked_image_variants", "bool", false)
       dt.preferences.write("enfuse_pro", "sentitiv_overwrite", "bool",true)
       enfuse_pro_combobox_existing_file.sensitive=true 
    end    
    
    end,
    reset_callback = function(self_image_variations) 
       dt.preferences.write("enfuse_pro", "checked_image_variants", "bool", false)
       dt.preferences.write("enfuse_pro", "sentitiv_overwrite", "bool",true)
       self_image_variations.value = false
       enfuse_pro_combobox_existing_file.sensitive=true
    end

}

enfuse_pro_button_save_preset = dt.new_widget("button")
{
      label = _('save fusion preset'),
      tooltip =_('save the selected fusion preset'),
      clicked_callback = function(save_fusion_type) 
        if (enfuse_pro_combobox_fusion_type.value == "1 - high dynamic range image") then
      -- preset HDR 1
          dt.preferences.write("enfuse_pro", "checked_hdr1_hard_masks", "bool", enfuse_pro_check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_hdr1_save_masks", "bool", enfuse_pro_check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_window_size", "integer", enfuse_pro_combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_edge_scale", "integer", enfuse_pro_combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_min_curvature", "integer", enfuse_pro_combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_hdr1_exposure_weight", "float", enfuse_pro_slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr1_saturation_weight", "float", enfuse_pro_slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr1_contrast_weight", "float", enfuse_pro_slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr1_exposure_optimum_weight", "float", enfuse_pro_slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr1_exposure_width_weight", "float",enfuse_pro_slider_exposure_width_weight.value)
          dt.print(_('preset HDR 1 saved')) 
          
          elseif (enfuse_pro_combobox_fusion_type.value == "2 - high dynamic range image") then
      -- preset HDR 2
          dt.preferences.write("enfuse_pro", "checked_hdr2_hard_masks", "bool", enfuse_pro_check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_hdr2_save_masks", "bool", enfuse_pro_check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_window_size", "integer", enfuse_pro_combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_edge_scale", "integer", enfuse_pro_combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_min_curvature", "integer", enfuse_pro_combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_hdr2_exposure_weight", "float", enfuse_pro_slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr2_saturation_weight", "float", enfuse_pro_slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr2_contrast_weight", "float", enfuse_pro_slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr2_exposure_optimum_weight", "float", enfuse_pro_slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr2_exposure_width_weight", "float",enfuse_pro_slider_exposure_width_weight.value)
          dt.print(_('preset HDR 2 saved')) 
          
           
          elseif (enfuse_pro_combobox_fusion_type.value == "3 - high dynamic range image") then
      -- preset HDR 3
          dt.preferences.write("enfuse_pro", "checked_hdr3_hard_masks", "bool", enfuse_pro_check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_hdr3_save_masks", "bool", enfuse_pro_check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_window_size", "integer", enfuse_pro_combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_edge_scale", "integer", enfuse_pro_combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_min_curvature", "integer", enfuse_pro_combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_hdr3_exposure_weight", "float", enfuse_pro_slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr3_saturation_weight", "float", enfuse_pro_slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr3_contrast_weight", "float", enfuse_pro_slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr3_exposure_optimum_weight", "float", enfuse_pro_slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr3_exposure_width_weight", "float",enfuse_pro_slider_exposure_width_weight.value)
          dt.print(_('preset HDR 3 saved')) 
          
          elseif (enfuse_pro_combobox_fusion_type.value == "1 - deep focus fusion image") then
      -- preset DFF 1
          dt.preferences.write("enfuse_pro", "checked_dff1_hard_masks", "bool", enfuse_pro_check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_dff1_save_masks", "bool", enfuse_pro_check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_dff1_contrast_window_size", "integer", enfuse_pro_combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_dff1_contrast_edge_scale", "integer", enfuse_pro_combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_dff1_contrast_min_curvature", "integer", enfuse_pro_combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_dff1_exposure_weight", "float", enfuse_pro_slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff1_saturation_weight", "float", enfuse_pro_slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff1_contrast_weight", "float", enfuse_pro_slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff1_exposure_optimum_weight", "float", enfuse_pro_slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff2_exposure_width_weight", "float",enfuse_pro_slider_exposure_width_weight.value)
          dt.print(_('preset DFF 1 saved')) 
          
          elseif (enfuse_pro_combobox_fusion_type.value == "2 - deep focus fusion image") then
      -- preset DFF 2
          dt.preferences.write("enfuse_pro", "checked_dff2_hard_masks", "bool", enfuse_pro_check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_dff2_save_masks", "bool", enfuse_pro_check_button_save_masks.value)  
          dt.preferences.write("enfuse_pro", "selected_dff2_contrast_window_size", "integer", enfuse_pro_combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_dff2_contrast_edge_scale", "integer", enfuse_pro_combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_dff2_contrast_min_curvature", "integer", enfuse_pro_combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_dff2_exposure_weight", "float", enfuse_pro_slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff2_saturation_weight", "float", enfuse_pro_slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff2_contrast_weight", "float", enfuse_pro_slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff2_exposure_optimum_weight", "float", enfuse_pro_slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff2_exposure_width_weight", "float",enfuse_pro_slider_exposure_width_weight.value)
          dt.print(_('preset DFF 2 saved')) 
          
          elseif (enfuse_pro_combobox_fusion_type.value == "3 - deep focus fusion image") then
      -- preset DFF 3
          dt.preferences.write("enfuse_pro", "checked_dff3_hard_masks", "bool", enfuse_pro_check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_dff3_save_masks", "bool", enfuse_pro_check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_dff3_contrast_window_size", "integer", enfuse_pro_combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_dff3_contrast_edge_scale", "integer", enfuse_pro_combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_dff3_contrast_min_curvature", "integer", enfuse_pro_combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_dff3_exposure_weight", "float", enfuse_pro_slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff3_saturation_weight", "float", enfuse_pro_slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff3_contrast_weight", "float", enfuse_pro_slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff3_exposure_optimum_weight", "float", enfuse_pro_slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff3_exposure_width_weight", "float",enfuse_pro_slider_exposure_width_weight.value)
          dt.print(_('preset DFF 3 saved')) 
          
          elseif (enfuse_pro_combobox_fusion_type.value == "free preset") then
      -- preset FREE
          dt.preferences.write("enfuse_pro", "checked_free_hard_masks", "bool", enfuse_pro_check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_free_save_masks", "bool", enfuse_pro_check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_free_contrast_window_size", "integer", enfuse_pro_combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_free_contrast_edge_scale", "integer", enfuse_pro_combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_free_contrast_min_curvature", "integer", enfuse_pro_combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_free_exposure_weight", "float", enfuse_pro_slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_free_saturation_weight", "float", enfuse_pro_slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_free_contrast_weight", "float", enfuse_pro_slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_free_exposure_optimum_weight", "float", enfuse_pro_slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_free_exposure_width_weight", "float",enfuse_pro_slider_exposure_width_weight.value)
          dt.print(_('preset free saved')) 
          else
          dt.print(_('unkown error'))
        end
      end
}

enfuse_pro_button_load_preset = dt.new_widget("button")
{
      label = _('load fusion preset defaults'),
      tooltip =_('load the default fusion preset settings'),
      clicked_callback = function(preset_default) 
        enfuse_pro_check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_hard_masks", "bool") 
        enfuse_pro_check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_save_masks", "bool") 
        enfuse_pro_combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_contrast_window_size", "integer")
        enfuse_pro_combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_contrast_edge_scale", "integer")
        enfuse_pro_combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_contrast_min_curvature", "integer")
        enfuse_pro_slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_exposure_weight", "float")
        enfuse_pro_slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_saturation_weight", "float")
        enfuse_pro_slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_contrast_weight", "float")
        enfuse_pro_slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_exposure_optimum_weight", "float")
        enfuse_pro_slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_exposure_width_weight", "float")
     end
      
}


enfuse_pro_combobox_output_format = dt.new_widget("combobox")
{
    label = _('file format'), 
    value = dt.preferences.read("enfuse_pro", "selected_output_format", "integer"), --2, "TIFF", "JPEG", "PNG","PNM","PBM","PGM","PPM",
    changed_callback = function(sel_output_format) 
      dt.preferences.write("enfuse_pro", "selected_output_format", "integer", sel_output_format.selected)
    end,
    "TIFF", "JPEG", "PNG","PNM","PBM","PPM",            
    reset_callback = function(self_output_format)
       self_output_format.value = dt.preferences.read("enfuse_pro", "selected_output_format", "integer")
    end
}  



enfuse_pro_combobox_fusion_type = dt.new_widget("combobox")
{
    label = _('fusion preset'), 
    tooltip =_('select the preset and save the preset\n if you want to reuse it or create an image\n variant'),
    value = dt.preferences.read("enfuse_pro", "selected_fusion_type", "integer"), --1, "high dynamic range image", "deep focus fusion image", "without preset",
    changed_callback = function(sel_fusion) 
       dt.preferences.write("enfuse_pro", "selected_fusion_type", "integer", sel_fusion.selected)
       -- preset HDR 1
       if (sel_fusion.value == "1 - high dynamic range image") then
        -- defaults for hdr images
        enfuse_pro_check_button_hard_masks.sensitive=false
        enfuse_pro_check_button_hard_masks.value=false
        enfuse_pro_slider_contrast_weight.sensitive=true
        enfuse_pro_check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr1_hard_masks", "bool") 
        enfuse_pro_check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr1_save_masks", "bool") 
        enfuse_pro_combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_hdr1_contrast_window_size", "integer")
        enfuse_pro_combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_hdr1_contrast_edge_scale", "integer")
        enfuse_pro_combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_hdr1_contrast_min_curvature", "integer") 
        enfuse_pro_slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_hdr1_exposure_weight", "float")
        enfuse_pro_slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_hdr1_saturation_weight", "float")
        enfuse_pro_slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_hdr1_contrast_weight", "float")
        enfuse_pro_slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_hdr1_exposure_optimum_weight", "float")
        enfuse_pro_slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_hdr1_exposure_width_weight", "float")
        
        
        -- preset HDR 2
       elseif (sel_fusion.value == "2 - high dynamic range image") then
        -- defaults for hdr images
        enfuse_pro_check_button_hard_masks.sensitive=false
        enfuse_pro_check_button_hard_masks.value=false
        enfuse_pro_slider_contrast_weight.sensitive=true
        enfuse_pro_check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr2_hard_masks", "bool") 
        enfuse_pro_check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr2_save_masks", "bool") 
        enfuse_pro_combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_hdr2_contrast_window_size", "integer")
        enfuse_pro_combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_hdr2_contrast_edge_scale", "integer")
        enfuse_pro_combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_hdr2_contrast_min_curvature", "integer")
        enfuse_pro_slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_hdr2_exposure_weight", "float")
        enfuse_pro_slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_hdr2_saturation_weight", "float")
        enfuse_pro_slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_hdr2_contrast_weight", "float")
        enfuse_pro_slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_hdr2_exposure_optimum_weight", "float")
        enfuse_pro_slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_hdr2_exposure_width_weight", "float")
        
         -- preset HDR 3
       elseif (sel_fusion.value == "3 - high dynamic range image") then
        -- defaults for hdr images
        enfuse_pro_check_button_hard_masks.sensitive=false
        enfuse_pro_check_button_hard_masks.value=false
        enfuse_pro_slider_contrast_weight.sensitive=true
        enfuse_pro_check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr3_hard_masks", "bool") 
        enfuse_pro_check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr3_save_masks", "bool") 
        enfuse_pro_combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_hdr3_contrast_window_size", "integer")
        enfuse_pro_combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_hdr3_contrast_edge_scale", "integer")
        enfuse_pro_combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_hdr3_contrast_min_curvature", "integer")
        enfuse_pro_slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_hdr3_exposure_weight", "float")
        enfuse_pro_slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_hdr3_saturation_weight", "float")
        enfuse_pro_slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_hdr3_contrast_weight", "float")
        enfuse_pro_slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_hdr3_exposure_optimum_weight", "float")
        enfuse_pro_slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_hdr3_exposure_width_weight", "float")
        
       -- preset DFF 1
       elseif (sel_fusion.value == "1 - deep focus fusion image") then
        -- defaults for focus stacking images
        enfuse_pro_check_button_hard_masks.sensitive=false
        enfuse_pro_check_button_hard_masks.value=true
        enfuse_pro_slider_contrast_weight.sensitive=false
        enfuse_pro_check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_dff1_hard_masks", "bool") 
        enfuse_pro_check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_dff1_save_masks", "bool") 
        enfuse_pro_combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_dff1_contrast_window_size", "integer")
        enfuse_pro_combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_dff1_contrast_edge_scale", "integer")
        enfuse_pro_combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_dff1_contrast_min_curvature", "integer")  
        enfuse_pro_slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_dff1_exposure_weight", "float")
        enfuse_pro_slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_dff1_saturation_weight", "float")
        enfuse_pro_slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_dff1_contrast_weight", "float")
        enfuse_pro_slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_dff1_exposure_optimum_weight", "float")
        enfuse_pro_slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_dff1_exposure_width_weight", "float")
        
        -- preset DFF 2
       elseif (sel_fusion.value == "2 - deep focus fusion image") then
        -- defaults for focus stacking images
        enfuse_pro_check_button_hard_masks.sensitive=false
        enfuse_pro_check_button_hard_masks.value=true
        enfuse_pro_slider_contrast_weight.sensitive=false
        enfuse_pro_check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_dff2_hard_masks", "bool") 
        enfuse_pro_check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_dff2_save_masks", "bool") 
        enfuse_pro_combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_dff2_contrast_window_size", "integer")
        enfuse_pro_combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_dff2_contrast_edge_scale", "integer")
        enfuse_pro_combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_dff2_contrast_min_curvature", "integer")  
        enfuse_pro_slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_dff2_exposure_weight", "float")
        enfuse_pro_slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_dff2_saturation_weight", "float")
        enfuse_pro_slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_dff2_contrast_weight", "float")
        enfuse_pro_slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_dff2_exposure_optimum_weight", "float")
        enfuse_pro_slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_dff2_exposure_width_weight", "float")
        
        -- preset DFF 3
       elseif (sel_fusion.value == "3 - deep focus fusion image") then
        -- defaults for focus stacking images
        enfuse_pro_check_button_hard_masks.sensitive=false
        enfuse_pro_check_button_hard_masks.value=true
        enfuse_pro_slider_contrast_weight.sensitive=false
        enfuse_pro_check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_dff3_hard_masks", "bool") 
        enfuse_pro_check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_dff3_save_masks", "bool") 
        enfuse_pro_combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_dff3_contrast_window_size", "integer")
        enfuse_pro_combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_dff3_contrast_edge_scale", "integer")
        enfuse_pro_combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_dff3_contrast_min_curvature", "integer") 
        enfuse_pro_slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_dff3_exposure_weight", "float")
        enfuse_pro_slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_dff3_saturation_weight", "float")
        enfuse_pro_slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_dff3_contrast_weight", "float")
        enfuse_pro_slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_dff3_exposure_optimum_weight", "float")
        enfuse_pro_slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_dff3_exposure_width_weight", "float")
      
       -- preset FREE
       elseif (sel_fusion.value == "free preset") then
        -- enfuse defaults
        enfuse_pro_check_button_hard_masks.sensitive=true
        enfuse_pro_check_button_hard_masks.value=false
        enfuse_pro_slider_contrast_weight.sensitive=true
        enfuse_pro_check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_free_hard_masks", "bool") 
        enfuse_pro_check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_free_save_masks", "bool") 
        enfuse_pro_combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_free_contrast_window_size", "integer")
        enfuse_pro_combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_free_contrast_edge_scale", "integer")
        enfuse_pro_combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_free_contrast_min_curvature", "integer")
        enfuse_pro_slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_free_exposure_weight", "float")
        enfuse_pro_slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_free_saturation_weight", "float")
        enfuse_pro_slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_free_contrast_weight", "float")
        enfuse_pro_slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_free_exposure_optimum_weight", "float")
        enfuse_pro_slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_free_exposure_width_weight", "float")
        
      
       end     
    end,
    "1 - high dynamic range image", "2 - high dynamic range image","3 - high dynamic range image","1 - deep focus fusion image", "2 - deep focus fusion image","3 - deep focus fusion image","free preset",  
    
    reset_callback = function(self_type)
       enfuse_pro_combobox_fusion_type.value = dt.preferences.read("enfuse_pro", "selected_fusion_type", "integer")
    end
} 




--FUNCTION  
  
local widget = dt.new_widget("box") {
    orientation = "vertical",
    enfuse_pro_label_align_options,
    enfuse_pro_label_line2,
    enfuse_pro_check_button_radial_distortion,
    enfuse_pro_check_button_optimize_field,
    enfuse_pro_check_button_optimize_image_center,
    enfuse_pro_check_button_auto_crop,
    enfuse_pro_check_button_distortion,
    enfuse_pro_combobox_grid_size,
    enfuse_pro_combobox_control_points,
    enfuse_pro_combobox_control_points_remove,
    enfuse_pro_combobox_correlation,
    enfuse_pro_separator1,
    enfuse_pro_separator1b,
    enfuse_pro_label_enfuse_options,
    enfuse_pro_label_line3,
    enfuse_pro_combobox_fusion_type,
    enfuse_pro_check_button_image_variations,
    enfuse_pro_slider_exposure_weight,
    enfuse_pro_slider_saturation_weight,
    enfuse_pro_slider_contrast_weight,
    enfuse_pro_slider_exposure_optimum_weight,
    enfuse_pro_slider_exposure_width_weight, 
    enfuse_pro_check_button_hard_masks,
    enfuse_pro_check_button_save_masks,
    enfuse_pro_combobox_contrast_edge_scale,
    enfuse_pro_combobox_contrast_min_curvature,
    enfuse_pro_combobox_contrast_window_size,
    enfuse_pro_button_save_preset,
    enfuse_pro_button_load_preset,
    enfuse_pro_separator2,
    enfuse_pro_separator2b,
    enfuse_pro_label_output_format,
    enfuse_pro_label_line1,
    enfuse_pro_combobox_output_format,
    enfuse_pro_label_path,
    enfuse_pro_file_chooser_button_path,
    enfuse_pro_combobox_existing_file,
}


local function GetFileName(full_path)
      local filename_with_suffix=full_path:match("[^/]+$" )
      return string.sub(filename_with_suffix,1, -5)
end

local function truncate(x)
      return x<0 and math.ceil(x) or math.floor(x)
end 

local function replace_comma_to_dot(s)
	return string.gsub(s, "%,", ".")
end

local function checkIfBinExists(bin)
  local handle = io.popen("which "..bin)
  local result = handle:read()
  local ret
  handle:close()
  if (result) then
    ret = true
  else
    ret = false
  end


  return ret
end

local function file_exists(name)
   local f=io.open(""..name.."","r")
   if f~=nil then 
       io.close(f) 
       return true 
   else 
       return false 
   end
end


local function remove_temp_files()
    
                    dt.print_error("rm "..images_to_align)
                    result_to_align_images=dt.control.execute("rm "..images_to_align)
                    dt.print_error("rm "..enfuse_pro_tmppath.."/aligned_*.tif")
                    result_aligned_images=dt.control.execute("rm "..enfuse_pro_tmppath.."/aligned_*.tif")
                    
end


local function create_enfuse_command()
-- create enfuse command
            enfuse_pro_enfuseStartCommand="enfuse "..enfuse_pro_cmd_enfuse_exposure_weight.." "..enfuse_pro_cmd_enfuse_saturation_weight.." "..enfuse_pro_cmd_enfuse_contrast_weight.." "..enfuse_pro_cmd_enfuse_exposure_optimum_weight.." "..enfuse_pro_cmd_enfuse_exposure_width_weight.." "..enfuse_pro_cmd_enfuse_hard_masks.." "..enfuse_pro_cmd_enfuse_save_masks.." "..enfuse_pro_cmd_enfuse_contrast_window_size.." "..enfuse_pro_cmd_enfuse_contrast_edge_scale.." "..enfuse_pro_cmd_enfuse_contrast_min_curvature.." "..enfuse_pro_cmd_enfuse_color_depth.." "..enfuse_pro_cmd_enfuse_compression.." "..enfuse_pro_cmd_output_image.." "..enfuse_pro_tmppath.."/aligned_*.tif"
            dt.print_error(enfuse_pro_enfuseStartCommand)
            -- execute enfuse
            resultenfuse=dt.control.execute(enfuse_pro_enfuseStartCommand)

             enfuse_pro_job.percent = enfuse_pro_job.percent + 0.10
            if (resultenfuse == 0) then
                 --copy exif tasgs
                 if (dt.preferences.read("module_enfuse_pro", "exiftool_copy_tags", "bool")) then
                   -- create exif command
                   enfuse_pro_exixStartCommand="exiftool -TagsFromFile \""..enfuse_pro_first_imagefile.."\" -exif:all --subifd:all -overwrite_original \""..enfuse_pro_cmd_output_path.."/"..(GetFileName(enfuse_pro_first_imagefile)).."-"..(GetFileName(enfuse_pro_last_imagefile)).."."..enfuse_pro_cmd_suffix_output_format.."\""
                   dt.print_error(enfuse_pro_exixStartCommand)
                   -- execute exif
                   resultexif=dt.control.execute(enfuse_pro_exixStartCommand)
                      if (dt.preferences.read("module_enfuse_pro", "add_image_to_db", "bool")) then
                          local image = dt.database.import(enfuse_pro_path_with_filename)
                      end
                      dt.print(_('process successfully completed'))
                   if (resultexif == 0) then
                    --   remove_temp_files()
                       dt.print(_('process successfully completed'))
                   else
                     --  remove_temp_files()
                       dt.print(_('ERROR: exiftool doesn\'t work. for more informations see terminal output')) 
                   --    enfuse_pro_job.valid = false
                   end
                 elseif (dt.preferences.read("module_enfuse_pro", "add_image_to_db", "bool")) then
                        local image = dt.database.import(enfuse_pro_path_with_filename)
                 end 
            else
              -- remove_temp_files()
               dt.print(_('ERROR: enfuse doesn\'t work. for more informations see terminal output'))
            end   

end


local function show_status(storage, image, format, filename,
  number, total, high_quality, extra_data)
     dt.print(_('export TIFF for image fusion ')..tostring(truncate(number)).." / "..tostring(truncate(total)))   
end

  



local function create_image_fusion(storage, image_table, extra_data) --finalize
enfuse_pro_job = dt.gui.create_job(_('creating HDR/DFF image'), true, stop_selection)
    -- check installed software
   if (not (checkIfBinExists("align_image_stack"))) then
     dt.print(_('ERROR: align_image_stack not found. please install hugin.'))
     dt.print_error(_('align_image_stack not found. please install hugin.'))
     dt.control.execute("rm "..enfuse_pro_tmppath.."/*.tif")
     enfuse_pro_job.valid = false
     return
   elseif  (not (checkIfBinExists("enfuse"))) then
     dt.print(_('ERROR: enfuse not found. please install enfuse.'))
     dt.print_error(_('enfuse not found. please install enfuse.'))
     dt.control.execute("rm "..enfuse_pro_tmppath.."*.tif")
     enfuse_pro_job.valid = false
     return
   end 
   enfuseVersionStartCommand='enfuse --version | grep "enfuse 4.2"'
   enfuse_version=dt.control.execute(enfuseVersionStartCommand)
   if (enfuse_version ~= 0) then
       dt.print(_('ERROR: wrong enfuse version found. the plugin works only with enfuse 4.2! please install enfuse version 4.2'))
       enfuse_pro_job.valid = false
       return
   end
   
 enfuse_pro_cmd_output_path = enfuse_pro_file_chooser_button_path.value
if (enfuse_pro_cmd_output_path == nil) then
     dt.print(_('ERROR: no target directory selected'))  
     enfuse_pro_job.valid = false
     return
else
   -- create align command
   dt.print(_('aligning images'))
   
   if (enfuse_pro_check_button_radial_distortion.value) then
   enfuse_pro_cmd_align_radial_distortion="-d"
   else 
   enfuse_pro_cmd_align_radial_distortion=""
   end
   
   if (enfuse_pro_check_button_optimize_field.value) then
   enfuse_pro_cmd_align_optimize_field="-m"   
   else
   enfuse_pro_cmd_align_optimize_field=""   
   end
   
   if (enfuse_pro_check_button_optimize_image_center.value) then
   enfuse_pro_cmd_align_optimize_center="-i"  
   else
   enfuse_pro_cmd_align_optimize_center=""    
   end
   
   if (enfuse_pro_check_button_auto_crop.value) then
   enfuse_pro_cmd_align_auto_crop="-C"         
   else
   enfuse_pro_cmd_align_auto_crop=""         
   end

   if (enfuse_pro_check_button_distortionvalue) then
   enfuse_pro_cmd_align_distortion="--distortion" 
   else
   enfuse_pro_cmd_align_distortion=""
   end

   enfuse_pro_cmd_align_grid_size="-g "..enfuse_pro_combobox_grid_size.value
   enfuse_pro_cmd_align_control_points="-c "..enfuse_pro_combobox_control_points.value           
   enfuse_pro_cmd_align_control_points_remove="-t "..enfuse_pro_combobox_control_points_remove.value
   enfuse_pro_cmd_align_correlation="--corr="..enfuse_pro_combobox_correlation.value
   if (dt.preferences.read("module_enfuse_pro", "align_use_gpu", "bool")) then
   enfuse_pro_cmd_align_use_gpu="--gpu"
   else
   enfuse_pro_cmd_align_use_gpu=""   
   end
   
   images_to_align =""
   local counted_images=0
   for _,v in pairs(image_table) do
                 images_to_align = images_to_align.."\"" ..v.."\" "
                 counted_images=counted_images+1
                 if (counted_images == 1) then
                 enfuse_pro_first_imagefile=v  
                 else
                 enfuse_pro_last_imagefile=v    
                 end
                
   end
enfuse_pro_job.percent = 0.1
   if (counted_images<=1) then
      dt.print(_('ERROR: not enough pictures selected. please select two or more images\nfrom the same object, but with different camera settings.'))
      dt.control.execute("rm "..enfuse_pro_tmppath.."/*.tif")
      enfuse_pro_job.valid = false
      return
   elseif (counted_images>=21) then  
      dt.print(_('you have selected more then 20 images. the align and fuse process could take a very long time! \nhave a nice beake.'))
   end    
   
   
    -- execute align_image_stack
   enfuse_pro_alignStartCommand="align_image_stack " ..enfuse_pro_cmd_align_radial_distortion.." "..enfuse_pro_cmd_align_optimize_field.." "..enfuse_pro_cmd_align_optimize_center.." "..enfuse_pro_cmd_align_auto_crop.." "..enfuse_pro_cmd_align_distortion.." "..enfuse_pro_cmd_align_grid_size.." "..enfuse_pro_cmd_align_control_points.." "..enfuse_pro_cmd_align_control_points_remove.." "..enfuse_pro_cmd_align_correlation.." "..enfuse_pro_cmd_align_use_gpu.." -a "..enfuse_pro_tmppath.."/aligned_ "..images_to_align
   
   dt.print_error(enfuse_pro_alignStartCommand)
   resultalign=dt.control.execute(enfuse_pro_alignStartCommand)
enfuse_pro_job.percent = 0.3
   if (resultalign == 0) then
    dt.print(_('aligning complete'))
-- enfuse with all HDR presets
       if (((enfuse_pro_check_button_image_variations.value) and (enfuse_pro_combobox_fusion_type.value == "1 - high dynamic range image")) or
           ((enfuse_pro_check_button_image_variations.value) and (enfuse_pro_combobox_fusion_type.value == "2 - high dynamic range image")) or
           ((enfuse_pro_check_button_image_variations.value) and (enfuse_pro_combobox_fusion_type.value == "3 - high dynamic range image"))) then
           
           
        for i = 1, 3 do
            dt.print(_('fuse image with HDR '..i..' presete'))
            enfuse_pro_cmd_enfuse_exposure_weight="--exposure-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_hdr"..i.."_exposure_weight", "float")))
            enfuse_pro_cmd_enfuse_saturation_weight="--saturation-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_hdr"..i.."_saturation_weight", "float")))    
            enfuse_pro_cmd_enfuse_contrast_weight="--contrast-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_hdr"..i.."_contrast_weight", "float")))
            enfuse_pro_cmd_enfuse_exposure_optimum_weight="--exposure-optimum="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_hdr"..i.."_exposure_optimum_weight", "float")))
            enfuse_pro_cmd_enfuse_exposure_width_weight="--exposure-width="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_hdr"..i.."_exposure_width_weight", "float")))
            
            if (enfuse_pro_check_button_hard_masks.value) then
            enfuse_pro_cmd_enfuse_hard_masks="--hard-mask"
            else 
            enfuse_pro_cmd_enfuse_hard_masks=""   
            end
       
            if (enfuse_pro_check_button_save_masks.value) then
            enfuse_pro_cmd_enfuse_save_masks="--save-masks"    
            else    
            enfuse_pro_cmd_enfuse_save_masks=""
            end
            
            enfuse_pro_cmd_enfuse_contrast_window_size="--contrast-window-size="..dt.preferences.read("enfuse_pro", "selected_hdr"..i.."_contrast_window_size", "integer")
            enfuse_pro_cmd_enfuse_contrast_edge_scale="--contrast-edge-scale="..dt.preferences.read("enfuse_pro", "selected_hdr"..i.."_contrast_edge_scale", "integer")
            enfuse_pro_cmd_enfuse_contrast_min_curvature="--contrast-min-curvature="..dt.preferences.read("enfuse_pro", "selected_hdr"..i.."_contrast_min_curvature", "integer") 
            enfuse_pro_cmd_output_path=enfuse_pro_file_chooser_button_path.value
            enfuse_pro_cmd_enfuse_color_depth="--depth="..dt.preferences.read("module_enfuse_pro", "image_color_depth", "enum")   
            
            if (enfuse_pro_combobox_output_format.value == "TIFF") then
               enfuse_pro_cmd_suffix_output_format="tif"
            elseif (enfuse_pro_combobox_output_format.value == "JPEG") then
               enfuse_pro_cmd_suffix_output_format="jpg"
            elseif (enfuse_pro_combobox_output_format.value == "PNG") then
               enfuse_pro_cmd_suffix_output_format="png"
            elseif (enfuse_pro_combobox_output_format.value == "PNM") then
               enfuse_pro_cmd_suffix_output_format="pnm"     
            elseif (enfuse_pro_combobox_output_format.value == "PBM") then
               enfuse_pro_cmd_suffix_output_format="pbm"   
            elseif (enfuse_pro_combobox_output_format.value == "PPM") then
               enfuse_pro_cmd_suffix_output_format="ppm"
            end
                        
            
            if (enfuse_pro_combobox_output_format.value == "JPEG") then --JPEG
              enfuse_pro_cmd_enfuse_compression="--compression="..truncate(dt.preferences.read("module_enfuse_pro", "compression_jpeg", "integer"))
            elseif (enfuse_pro_combobox_output_format.value == "TIFF") then --TIFF
              enfuse_pro_cmd_enfuse_compression="--compression="..dt.preferences.read("module_enfuse_pro", "compression_tiff", "enum")
            else
             enfuse_pro_cmd_enfuse_compression=""   
            end
            
            enfuse_pro_path_with_filename=enfuse_pro_cmd_output_path.."/"..(GetFileName(enfuse_pro_first_imagefile)).."-"..(GetFileName(enfuse_pro_last_imagefile)).."."..enfuse_pro_cmd_suffix_output_format
                dt.print_error(enfuse_pro_path_with_filename)
               while (file_exists(enfuse_pro_path_with_filename)) do
                   enfuse_pro_cmd_output_image_index=enfuse_pro_cmd_output_image_index+1
                   if enfuse_pro_cmd_output_image_index <= 9 then
                   enfuse_pro_outputindex="0"..tostring(enfuse_pro_cmd_output_image_index)
                   else
                   enfuse_pro_outputindex=tostring(enfuse_pro_cmd_output_image_index)   
                   end
                   
                   enfuse_pro_path_with_filename=enfuse_pro_cmd_output_path.."/"..(GetFileName(enfuse_pro_first_imagefile)).."-"..(GetFileName(enfuse_pro_last_imagefile)).."_"..enfuse_pro_outputindex.."."..enfuse_pro_cmd_suffix_output_format
                  
               end 
               enfuse_pro_cmd_output_image="--output=\""..enfuse_pro_path_with_filename.."\""
               enfuse_pro_cmd_output_image_index=0
            create_enfuse_command()
        end
            remove_temp_files()
            enfuse_pro_job.valid = false
            dt.print(_('process successfully completed'))
            
           
-- enfuse with all DFF presets 
        elseif (((enfuse_pro_check_button_image_variations.value) and (enfuse_pro_combobox_fusion_type.value == "1 - deep focus fusion image")) or
                ((enfuse_pro_check_button_image_variations.value) and (enfuse_pro_combobox_fusion_type.value == "2 - deep focus fusion image")) or
                ((enfuse_pro_check_button_image_variations.value) and (enfuse_pro_combobox_fusion_type.value == "3 - deep focus fusion image"))) then

          
           
        for i = 1, 3 do
            dt.print(_('fuse image with DFF '..i..' presete')) 
            enfuse_pro_cmd_enfuse_exposure_weight="--exposure-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_dff"..i.."_exposure_weight", "float")))
            enfuse_pro_cmd_enfuse_saturation_weight="--saturation-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_dff"..i.."_saturation_weight", "float")))    
            enfuse_pro_cmd_enfuse_contrast_weight="--contrast-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_dff"..i.."_contrast_weight", "float")))
            enfuse_pro_cmd_enfuse_exposure_optimum_weight="--exposure-optimum="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_dff"..i.."_exposure_optimum_weight", "float")))
            enfuse_pro_cmd_enfuse_exposure_width_weight="--exposure-width="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_dff"..i.."_exposure_width_weight", "float")))
            
            if (enfuse_pro_check_button_hard_masks.value) then
            enfuse_pro_cmd_enfuse_hard_masks="--hard-mask"
            else 
            enfuse_pro_cmd_enfuse_hard_masks=""   
            end
       
            if (enfuse_pro_check_button_save_masks.value) then
            enfuse_pro_cmd_enfuse_save_masks="--save-masks"    
            else    
            enfuse_pro_cmd_enfuse_save_masks=""
            end
            
            
            enfuse_pro_cmd_enfuse_contrast_window_size="--contrast-window-size="..dt.preferences.read("enfuse_pro", "selected_dff"..i.."_contrast_window_size", "integer")
            enfuse_pro_cmd_enfuse_contrast_edge_scale="--contrast-edge-scale="..dt.preferences.read("enfuse_pro", "selected_dff"..i.."_contrast_edge_scale", "integer")
            enfuse_pro_cmd_enfuse_contrast_min_curvature="--contrast-min-curvature="..dt.preferences.read("enfuse_pro", "selected_dff"..i.."_contrast_min_curvature", "integer") 
            enfuse_pro_cmd_output_path=enfuse_pro_file_chooser_button_path.value
            enfuse_pro_cmd_enfuse_color_depth="--depth="..dt.preferences.read("module_enfuse_pro", "image_color_depth", "enum")   
            
                       
            if (enfuse_pro_combobox_output_format.value == "TIFF") then
               enfuse_pro_cmd_suffix_output_format="tif"
            elseif (enfuse_pro_combobox_output_format.value == "JPEG") then
               enfuse_pro_cmd_suffix_output_format="jpg"
            elseif (enfuse_pro_combobox_output_format.value == "PNG") then
               enfuse_pro_cmd_suffix_output_format="png"
            elseif (enfuse_pro_combobox_output_format.value == "PNM") then
               enfuse_pro_cmd_suffix_output_format="pnm"     
            elseif (enfuse_pro_combobox_output_format.value == "PBM") then
               enfuse_pro_cmd_suffix_output_format="pbm"   
            elseif (enfuse_pro_combobox_output_format.value == "PPM") then
               enfuse_pro_cmd_suffix_output_format="ppm"
            end
            
            
            if (enfuse_pro_combobox_output_format.value == "JPEG") then --JPEG
              enfuse_pro_cmd_enfuse_compression="--compression="..truncate(dt.preferences.read("module_enfuse_pro", "compression_jpeg", "integer"))
            elseif (enfuse_pro_combobox_output_format.value == "TIFF") then --TIFF
              enfuse_pro_cmd_enfuse_compression="--compression="..dt.preferences.read("module_enfuse_pro", "compression_tiff", "enum")
            else
             enfuse_pro_cmd_enfuse_compression=""   
            end
            
            enfuse_pro_path_with_filename=enfuse_pro_cmd_output_path.."/"..(GetFileName(enfuse_pro_first_imagefile)).."-"..(GetFileName(enfuse_pro_last_imagefile)).."."..enfuse_pro_cmd_suffix_output_format
                dt.print_error(enfuse_pro_path_with_filename)
               while (file_exists(enfuse_pro_path_with_filename)) do
                   enfuse_pro_cmd_output_image_index=enfuse_pro_cmd_output_image_index+1
                   if enfuse_pro_cmd_output_image_index <= 9 then
                   enfuse_pro_outputindex="0"..tostring(enfuse_pro_cmd_output_image_index)
                   else
                   enfuse_pro_outputindex=tostring(enfuse_pro_cmd_output_image_index)   
                   end
                   
                   enfuse_pro_path_with_filename=enfuse_pro_cmd_output_path.."/"..(GetFileName(enfuse_pro_first_imagefile)).."-"..(GetFileName(enfuse_pro_last_imagefile)).."_"..enfuse_pro_outputindex.."."..enfuse_pro_cmd_suffix_output_format
                  
               end 
               enfuse_pro_cmd_output_image="--output=\""..enfuse_pro_path_with_filename.."\""
               enfuse_pro_cmd_output_image_index=0
            create_enfuse_command()
            enfuse_pro_job.valid = false
        end
            remove_temp_files()
            dt.print(_('process successfully completed'))
           
-- enfuse with GUI settings          
        else
            if (enfuse_pro_combobox_fusion_type.value == "1 - high dynamic range image") then
               dt.print(_('enfuse with value from preset HDR 1')) 
            elseif (enfuse_pro_combobox_fusion_type.value == "2 - high dynamic range image") then
               dt.print(_('enfuse with value from preset HDR 2')) 
            elseif (enfuse_pro_combobox_fusion_type.value == "3 - high dynamic range image") then
               dt.print(_('enfuse with value from preset HDR 3')) 
            elseif (enfuse_pro_combobox_fusion_type.value == "1 - deep focus fusion image") then
               dt.print(_('enfuse with value from preset DFF 1')) 
            elseif (enfuse_pro_combobox_fusion_type.value == "2 - deep focus fusion image") then
               dt.print(_('enfuse with value from preset DFF 2'))
            elseif (enfuse_pro_combobox_fusion_type.value == "3 - deep focus fusion image") then
               dt.print(_('enfuse with value from preset DFF 3'))
            elseif (enfuse_pro_combobox_fusion_type.value == "free preset") then
               dt.print(_('enfuse with value from free preset'))
            end
       
            enfuse_pro_cmd_enfuse_exposure_weight="--exposure-weight="..(replace_comma_to_dot(enfuse_pro_slider_exposure_weight.value))
            enfuse_pro_cmd_enfuse_saturation_weight="--saturation-weight="..(replace_comma_to_dot(enfuse_pro_slider_saturation_weight.value))              
            enfuse_pro_cmd_enfuse_contrast_weight="--contrast-weight="..(replace_comma_to_dot(enfuse_pro_slider_contrast_weight.value))
            enfuse_pro_cmd_enfuse_exposure_optimum_weight="--exposure-optimum="..(replace_comma_to_dot(enfuse_pro_slider_exposure_optimum_weight.value))
            enfuse_pro_cmd_enfuse_exposure_width_weight="--exposure-width="..(replace_comma_to_dot(enfuse_pro_slider_exposure_width_weight.value))
       
            if (enfuse_pro_check_button_hard_masks.value) then
            enfuse_pro_cmd_enfuse_hard_masks="--hard-mask"
            else 
            enfuse_pro_cmd_enfuse_hard_masks=""   
            end
       
            if (enfuse_pro_check_button_save_masks.value) then
            enfuse_pro_cmd_enfuse_save_masks="--save-masks"    
            else    
            enfuse_pro_cmd_enfuse_save_masks=""
            end
       
            enfuse_pro_cmd_enfuse_contrast_window_size="--contrast-window-size="..enfuse_pro_combobox_contrast_window_size.value
            enfuse_pro_cmd_enfuse_contrast_edge_scale="--contrast-edge-scale="..enfuse_pro_combobox_contrast_edge_scale.value
            enfuse_pro_cmd_enfuse_contrast_min_curvature="--contrast-min-curvature="..enfuse_pro_combobox_contrast_min_curvature.value
            
            enfuse_pro_cmd_output_path=enfuse_pro_file_chooser_button_path.value
            enfuse_pro_cmd_enfuse_color_depth="--depth="..dt.preferences.read("module_enfuse_pro", "image_color_depth", "enum")
            
            if (enfuse_pro_combobox_output_format.value == "TIFF") then
               enfuse_pro_cmd_suffix_output_format="tif"
            elseif (enfuse_pro_combobox_output_format.value == "JPEG") then
               enfuse_pro_cmd_suffix_output_format="jpg"
            elseif (enfuse_pro_combobox_output_format.value == "PNG") then
               enfuse_pro_cmd_suffix_output_format="png"
            elseif (enfuse_pro_combobox_output_format.value == "PNM") then
               enfuse_pro_cmd_suffix_output_format="pnm"     
            elseif (enfuse_pro_combobox_output_format.value == "PBM") then
               enfuse_pro_cmd_suffix_output_format="pbm"   
            elseif (enfuse_pro_combobox_output_format.value == "PPM") then
               enfuse_pro_cmd_suffix_output_format="ppm"
            end
            
            
            if (enfuse_pro_combobox_output_format.value == "JPEG") then --JPEG
              enfuse_pro_cmd_enfuse_compression="--compression="..truncate(dt.preferences.read("module_enfuse_pro", "compression_jpeg", "integer"))
            elseif (enfuse_pro_combobox_output_format.value == "TIFF") then --TIFF
              enfuse_pro_cmd_enfuse_compression="--compression="..dt.preferences.read("module_enfuse_pro", "compression_tiff", "enum")
            else
             enfuse_pro_cmd_enfuse_compression=""   
            end

            
            if (enfuse_pro_combobox_existing_file.selected == 1) then
                enfuse_pro_path_with_filename=enfuse_pro_cmd_output_path.."/"..(GetFileName(enfuse_pro_first_imagefile)).."-"..(GetFileName(enfuse_pro_last_imagefile)).."."..enfuse_pro_cmd_suffix_output_format
                dt.print_error("Datei mit Pfad")
                dt.print_error(enfuse_pro_path_with_filename)
               while (file_exists(enfuse_pro_path_with_filename)) do
                   enfuse_pro_cmd_output_image_index=enfuse_pro_cmd_output_image_index+1
                   if enfuse_pro_cmd_output_image_index <= 9 then
                   enfuse_pro_outputindex="0"..tostring(enfuse_pro_cmd_output_image_index)
                   else
                   enfuse_pro_outputindex=tostring(enfuse_pro_cmd_output_image_index)   
                   end
                   
                   enfuse_pro_path_with_filename=enfuse_pro_cmd_output_path.."/"..(GetFileName(enfuse_pro_first_imagefile)).."-"..(GetFileName(enfuse_pro_last_imagefile)).."_"..enfuse_pro_outputindex.."."..enfuse_pro_cmd_suffix_output_format
                  
               end 
               enfuse_pro_cmd_output_image="--output=\""..enfuse_pro_path_with_filename.."\""
               enfuse_pro_cmd_output_image_index=0
            else
                enfuse_pro_cmd_output_image="--output=\""..enfuse_pro_cmd_output_path.."/"..(GetFileName(enfuse_pro_first_imagefile)).."-"..(GetFileName(enfuse_pro_last_imagefile)).."."..enfuse_pro_cmd_suffix_output_format.."\""
            end
            dt.print_error(enfuse_pro_path_with_filename)
            create_enfuse_command()
            remove_temp_files()
            enfuse_pro_job.valid = false
       end
   else
      remove_temp_files() 
    dt.print(_('ERROR: align_image_stack doesn\'t work. For more information see terminal output'))
    enfuse_pro_job.valid = false
   end
   
end    
end


-- limit export to tiff
local function support_format(storage, format)
  fmt = string.lower(format.name)
  if string.match(fmt,"tiff") == nil then
    return false
  else
    return true
  end   
end  



-- REGISTER
dt.register_storage("module_enfuse_pro", _('pseudo hdr or dff image'), show_status, create_image_fusion, support_format, nil, widget)

dt.preferences.register("module_enfuse_pro",        
                        "align_use_gpu",                                          -- name
                        "bool",                                                   -- type
                        _('enfuse pro: use GPU for remaping'),                       -- label
                        _('set the GPU remapping for image align'),                  -- tooltip
                        false)                                                    -- default
                        
dt.preferences.register("module_enfuse_pro",        
                        "exiftool_copy_tags",                                     -- name
                        "bool",                                                   -- type
                        _('enfuse pro: copy exif tags'),                             -- label
                        _('copy the exif tags from the first image to the target'),  -- tooltip
                        true)                                                     -- default                        

dt.preferences.register("module_enfuse_pro",        
                        "add_image_to_db",                                        -- name
                        "bool",                                                   -- type
                        _('enfuse pro: add fused image to database'),                -- label
                        _('add the fused image to the darktable database'),          -- tooltip
                        false)                                                    -- default           
                        
                        
dt.preferences.register("module_enfuse_pro",        
                        "compression_jpeg",                        -- name
                        "integer",                                 -- type
                        _('enfuse pro: JPEG compression'),            -- label
                        _('set the compression for JPEG files'),      -- tooltip
                        98,                                        -- default
                        50,                                        -- min
                        100)                                       -- max
                        
dt.preferences.register("module_enfuse_pro",        
                        "compression_tiff",                        -- name
                        "enum",                                    -- type
                        _('enfuse pro: TIFF compression'),            -- label
                        _('set the compression type for tiff files'), -- tooltip
                        "LZW",                                     -- default
                        "NONE", "DEFLATE","LZW","PACKBITS")        -- values

                        
dt.preferences.register("module_enfuse_pro",        
                        "image_color_depth",                       -- name
                        "enum",                                    -- type
                        _('enfuse pro: image color depth (bit)'),     -- label
                        _('set the output color depth'),              -- tooltip
                        "16",                                      -- default
                        "8", "16","32","r32","r64")                -- values
                        