--[[
  Enfuse professional plugin for darktable 2.2.X and 2.3.X

  copyright (c) 2017  Holger Klemm
  
  darktable is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  darktable is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with darktable.  If not, see <http://www.gnu.org/licenses/>.
]]

--[[
Version 2.1.2 for darktable 2.2.X

Known bugs:   

Change report:
- fix exif option
- fix re-import option
- add proess bar
- add french translation
   
   
ADDITIONAL SOFTWARE NEEDED FOR THIS SCRIPT
* align_image_stack
* enfuse
* exiftool

USAGE
* require this file from your main luarc config file.

This plugin will add the new export modul "fusion to HDR or DFF image".
]]

local dt = require "darktable"
local gettext = dt.gettext

-- work with LUA API version 4.0.0 and 5.0.0
dt.configuration.check_version(...,{4,0,0},{5,0,0})

-- Tell gettext where to find the .mo file translating messages for a particular domain
gettext.bindtextdomain("enfuse_pro",dt.configuration.config_dir.."/lua/")

local function _(msgid)
    return gettext.dgettext("enfuse_pro", msgid)
end


-- command variables
-- align
cmd_align_radial_distortion=""
cmd_align_optimize_field=""            
cmd_align_optimize_center=""          
cmd_align_auto_crop=""  
cmd_align_distortion=""
cmd_align_grid_size=""
cmd_align_control_points=""  
cmd_align_control_points_remove=""
cmd_align_correlation=""   
cmd_align_use_gpu=""
-- enfuse
cmd_enfuse_exposure_weight=""                
cmd_enfuse_saturation_weight=""                
cmd_enfuse_contrast_weight=""
cmd_enfuse_exposure_optimum_weight="" 
cmd_enfuse_exposure_width_weight=""
cmd_enfuse_hard_masks=""
cmd_enfuse_save_masks=""
cmd_enfuse_contrast_window_size=""
cmd_enfuse_contrast_edge_scale=""
cmd_enfuse_contrast_min_curvature=""

cmd_enfuse_color_depth=""
cmd_enfuse_compression=""

first_imagefile=""
last_imagefile=""
cmd_tmp_path=""
cmd_output_path=""
cmd_output_image=""
cmd_output_image_index=0
path_with_filename=""
homepath=os.getenv("HOME")
tmppath=homepath.."/.local/tmp"
-- exif
cmd_exif_copy_exif=""
-- output
cmd_suffix_output_format=""
-- commands
alignStartCommand=""
enfuseStartCommand=""
exixStartCommand=""

outputindex=0
job=0
-- initialize combobox and checkbox value for default
if (dt.preferences.read("enfuse_pro",  "selected_fusion", "integer") == 0) or (dt.preferences.read("enfuse_pro",  "selected_overwrite", "integer") == 0) then
    -- align defaults
   dt.preferences.write("enfuse_pro", "selected_fusion", "integer", 1)           --Typ HDR
   dt.preferences.write("enfuse_pro", "checked_radial_distortion", "bool", false)      
   dt.preferences.write("enfuse_pro", "checked_optimize_field", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_optimize_image_center", "bool", true) 
   dt.preferences.write("enfuse_pro", "checked_auto_crop", "bool", true) 
   dt.preferences.write("enfuse_pro", "checked_distortion", "bool", true) 
   dt.preferences.write("enfuse_pro", "selected_grid_size", "integer", 5)
   dt.preferences.write("enfuse_pro", "selected_control_points", "integer", 8)
   dt.preferences.write("enfuse_pro", "selected_control_points_remove", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_correlation", "integer", 9)
   -- enfuse defaults
   dt.preferences.write("enfuse_pro", "selected_fusion_type", "integer", 1)
   dt.preferences.write("enfuse_pro", "checked_image_variants", "bool", false)
   dt.preferences.write("enfuse_pro", "checked_hard_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_contrast_min_curvature", "integer", 1) 
   dt.preferences.write("enfuse_pro", "set_exposure_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_saturation_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_contrast_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_exposure_width_weight", "float",0.2)
   dt.preferences.write("enfuse_pro", "selected_overwrite", "integer",1)
   dt.preferences.write("enfuse_pro", "sentitiv_overwrite", "bool",true)
   
   
   -- preset HDR 1
   dt.preferences.write("enfuse_pro", "checked_hdr1_hard_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_hdr1_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_min_curvature", "integer", 1) 
   dt.preferences.write("enfuse_pro", "set_hdr1_exposure_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_hdr1_saturation_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr1_contrast_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_hdr1_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr1_exposure_width_weight", "float",0.2)
   
   -- preset HDR 2
   dt.preferences.write("enfuse_pro", "checked_hdr2_hard_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_hdr2_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_min_curvature", "integer", 1) 
   dt.preferences.write("enfuse_pro", "set_hdr2_exposure_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_hdr2_saturation_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr2_contrast_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_hdr2_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr2_exposure_width_weight", "float",0.2)
   
   -- preset HDR 3
   dt.preferences.write("enfuse_pro", "checked_hdr3_hard_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_hdr3_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_min_curvature", "integer", 1)  
   dt.preferences.write("enfuse_pro", "set_hdr3_exposure_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_hdr3_saturation_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr3_contrast_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_hdr3_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_hdr3_exposure_width_weight", "float",0.2)
   
   -- preset DFF 1
   dt.preferences.write("enfuse_pro", "checked_dff1_hard_masks", "bool", true) 
   dt.preferences.write("enfuse_pro", "checked_dff1_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_dff1_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_dff1_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_dff1_contrast_min_curvature", "integer", 1)  
   dt.preferences.write("enfuse_pro", "set_dff1_exposure_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff1_saturation_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff1_contrast_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_dff1_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_dff1_exposure_width_weight", "float",0.2)
   
   -- preset DFF 2
   dt.preferences.write("enfuse_pro", "checked_dff2_hard_masks", "bool", true) 
   dt.preferences.write("enfuse_pro", "checked_dff2_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_dff2_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_dff2_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_dff2_contrast_min_curvature", "integer", 1)  
   dt.preferences.write("enfuse_pro", "set_dff2_exposure_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff2_saturation_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff2_contrast_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_dff2_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_dff2_exposure_width_weight", "float",0.2)
   
   -- preset DFF 3
   dt.preferences.write("enfuse_pro", "checked_dff3_hard_masks", "bool", true) 
   dt.preferences.write("enfuse_pro", "checked_dff3_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_dff3_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_dff3_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_dff3_contrast_min_curvature", "integer", 1) 
   dt.preferences.write("enfuse_pro", "set_dff3_exposure_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff3_saturation_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_dff3_contrast_weight", "float", 1.0)
   dt.preferences.write("enfuse_pro", "set_dff3_exposure_optimum_weight", "float", 0.5)
   dt.preferences.write("enfuse_pro", "set_dff3_exposure_width_weight", "float",0.2)
   
    -- preset FREE
   dt.preferences.write("enfuse_pro", "checked_free_hard_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "checked_free_save_masks", "bool", false) 
   dt.preferences.write("enfuse_pro", "selected_free_contrast_window_size", "integer", 3)
   dt.preferences.write("enfuse_pro", "selected_free_contrast_edge_scale", "integer", 1)
   dt.preferences.write("enfuse_pro", "selected_free_contrast_min_curvature", "integer", 1)  
   dt.preferences.write("enfuse_pro", "set_free_exposure_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_free_saturation_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_free_contrast_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_free_exposure_optimum_weight", "float", 0.0)
   dt.preferences.write("enfuse_pro", "set_free_exposure_width_weight", "float",0.0)
   
   -- output
   dt.preferences.write("enfuse_pro", "selected_output_format", "integer", 2)
      
end


--GUI
local separator1 = dt.new_widget("separator")
{
}
local separator1b = dt.new_widget("separator")
{
}

local separator2 = dt.new_widget("separator")
{}

local separator2b = dt.new_widget("separator")
{}

local label_line1= dt.new_widget("label")
{
     label = "_______________________________________________",
     ellipsize = "start",
     halign = "end"
}

local label_line2= dt.new_widget("label")
{
     label = "_______________________________________________",
     ellipsize = "start",
     halign = "end"
}

local label_line3= dt.new_widget("label")
{
     label = "_______________________________________________",
     ellipsize = "start",
     halign = "end"
}

local label_align_options= dt.new_widget("label")
{
     label = _('image align options'),
     ellipsize = "start",
     halign = "end"
}

local label_enfuse_options= dt.new_widget("label")
{
     label = _('image fusion options'),
     ellipsize = "start",
     halign = "end"
}


local label_output_format= dt.new_widget("label")
{
     label = _('target file'),
     ellipsize = "start",
     halign = "end"
}

local label_path = dt.new_widget("label")
{
     label = _('directory'),
     ellipsize = "start",
     halign = "start"
}





check_button_radial_distortion = dt.new_widget("check_button")
{
    label = _('optimize radial distortion for all images'), 
    value = dt.preferences.read("enfuse_pro", "checked_radial_distortion", "bool"),
    tooltip =_('optimize radial distortion for all images, \nexcept for first'),   
    clicked_callback = function(distortion)   
      if (distortion.value) then
             dt.preferences.write("enfuse_pro", "checked_radial_distortion", "bool", true)
             cmd_align_radial_distortion="-d"           
          --   return
          else
             dt.preferences.write("enfuse_pro", "checked_radial_distortion", "bool", false)
             cmd_align_radial_distortion=""
         --    return
          end
    end,
}

check_button_optimize_field = dt.new_widget("check_button")
{
    label = _('optimize field of view for all images'), 
    value = dt.preferences.read("enfuse_pro", "checked_optimize_field", "bool"),
    tooltip =_('optimize field of view for all images, except for first. \nUseful for aligning focus stacks (DFF) with slightly \ndifferent magnification.'), 
    clicked_callback = function(field)   
          if (field.value) then
             dt.preferences.write("enfuse_pro", "checked_optimize_field", "bool", true)
             cmd_align_optimize_field="-m"           
          --   return
          else
             dt.preferences.write("enfuse_pro", "checked_optimize_field", "bool", false)
             cmd_align_optimize_field=""
         --    return
          end
    end,
}


check_button_optimize_image_center = dt.new_widget("check_button")
{
    label = _('optimize image center shift for all images'), 
    value = dt.preferences.read("enfuse_pro", "checked_optimize_image_center", "bool"),
    tooltip =_('optimize image center shift for all images, \nexcept for first.'),   
    clicked_callback = function(center)   
         if (center.value) then
             dt.preferences.write("enfuse_pro", "checked_optimize_image_center", "bool", true)
             cmd_align_optimize_center="-i"           
          --   return
         else
             dt.preferences.write("enfuse_pro", "checked_optimize_image_center", "bool", false)
             cmd_align_optimize_center=""
         --    return
         end  
    end,
}


check_button_auto_crop = dt.new_widget("check_button")
{
    label = _('auto crop the image'), 
    value = dt.preferences.read("enfuse_pro", "checked_auto_crop", "bool"),
    tooltip =_('auto crop the image to the area covered by all images.'),   
    clicked_callback = function(auto)   
         if (auto.value) then
             dt.preferences.write("enfuse_pro", "checked_auto_crop", "bool", true)
             cmd_align_auto_crop="-C"           
          --   return
         else
             dt.preferences.write("enfuse_pro", "checked_auto_crop", "bool", false)
             cmd_align_auto_crop=""
         --    return
         end  
    end,
}


check_button_distortion = dt.new_widget("check_button")
{
    label = _('load distortion from lens database'), 
    value = dt.preferences.read("enfuse_pro", "checked_distortion", "bool"),
    tooltip =_('try to load distortion information from lens database'),   
    clicked_callback = function(distortion)   
         if (distortion.value) then
             dt.preferences.write("enfuse_pro", "checked_distortion", "bool", true)
             cmd_align_distortion="--distortion"           
          --   return
         else
             dt.preferences.write("enfuse_pro", "checked_distortion", "bool", false)
             cmd_align_distortion=""
         --    return
         end  
    end,
}


check_button_hard_masks = dt.new_widget("check_button")
{
    label = _('hard mask'), 
    value = dt.preferences.read("enfuse_pro", "checked_hard_masks", "bool"),
    tooltip =_('force hard blend masks on the finest scale. this avoids \naveraging of fine details (only), at the expense \nof increasing the noise. this improves the \nsharpness of focus stacks considerably.\ndefault (soft mask)'),   
    reset_callback = function(self_hard_mask) 
       self_hard_mask.value = dt.preferences.read("enfuse_pro", "checked_hard_masks", "bool")
    end
    
}

check_button_save_masks = dt.new_widget("check_button")
{
    label = _('save masks'), 
    value = dt.preferences.read("enfuse_pro", "checked_save_masks", "bool"),
    tooltip =_('Save the generated weight masks to your home directory,\nenblend saves masks as 8 bit grayscale, \ni.e. single channel images. \nfor accuracy we recommend to choose a lossless format.'),  
    reset_callback = function(self_save_mask) 
       self_save_mask.value = dt.preferences.read("enfuse_pro", "checked_save_masks", "bool")
    end
    
}


slider_exposure_weight = dt.new_widget("slider")
{
  label = _('exposure weight'),
  tooltip = _('set the relative weight of the well-exposedness criterion \nas defined by the chosen exposure weight function. \nincreasing this weight relative to the others will\n make well-exposed pixels contribute more to\n the final output. \ndefault: (1.0)'),
  hard_min = 0,
  hard_max = 1,
  value = dt.preferences.read("enfuse_pro", "set_exposure_weight", "float") --1 default

}

slider_saturation_weight = dt.new_widget("slider")
{
  label = _('saturation weight'),
  tooltip = _('set the relative weight of high-saturation pixels. \nincreasing this weight makes pixels with high \nsaturation contribute more to the final output. \ndefault: (0.2)'),
  hard_min = 0,
  hard_max = 1,
  value = dt.preferences.read("enfuse_pro", "set_saturation_weight", "float"), --0.5
  
  
  
}

slider_contrast_weight = dt.new_widget("slider")
{
  label = _('contrast weight'),
  tooltip = _('sets the relative weight of high local-contrast pixels. \ndefault: (0.0).'),
  hard_min = 0,
  hard_max = 1,
  value = dt.preferences.read("enfuse_pro", "set_contrast_weight", "float")--0 default
 
}

slider_exposure_optimum_weight = dt.new_widget("slider")
{
  label = _('exposure optimum'),
  tooltip = _('determine at what normalized exposure value\n the optimum exposure of the input images\n is. this is, set the position of the maximum\n of the exposure weight curve. use this \noption to fine-tune exposure weighting. \ndefault: (0.5)'),
  hard_min = 0,
  hard_max = 1,
  value = dt.preferences.read("enfuse_pro", "set_exposure_optimum_weight", "float")--0.5 default0

}

slider_exposure_width_weight = dt.new_widget("slider")
{
  label = _('exposure width'),
  tooltip = _('set the characteristic width (FWHM) of the exposure \nweight function. low numbers give less weight to \npixels that are far from the user-defined \noptimum and vice versa. use this option to \nfine-tune exposure weighting. \ndefault: (0.2)'),
  hard_min = 0,
  hard_max = 1,
  value = dt.preferences.read("enfuse_pro", "set_exposure_width_weight", "float") --0.2 default

}




file_chooser_button_path = dt.new_widget("file_chooser_button")
{
    title = _('Select export path'),  -- The title of the window when choosing a file
    is_directory = true,             -- True if the file chooser button only allows directories to be selecte
    tooltip =_('select the target directory for the fused image. \nthe filename is created automatically.')
}



combobox_grid_size = dt.new_widget("combobox")
{
    label = _('image grid size'), 
    tooltip =_('break image into a rectangular grid \nand attempt to find num control points in each section.\ndefault: (5x5)'),
    value =  dt.preferences.read("enfuse_pro", "selected_grid_size", "integer"), 
    changed_callback = function(sel_grid_size) 
    end,
    "1", "2", "3","4","5","6","7","8","9",
    
    reset_callback = function(self_grid)
       self_grid.value = dt.preferences.read("enfuse_pro", "selected_grid_size", "integer")
    end
} 


combobox_control_points = dt.new_widget("combobox")
{
    label = _('control points/grid'), 
    tooltip =_('number of control points (per grid, see option -g) \nto create between adjacent images \ndefault: (8).'),
    value =   dt.preferences.read("enfuse_pro", "selected_control_points", "integer"),   --8, "1", "2", "3","4","5","6","7","8","9",
    changed_callback = function(sel_control_points) 
    end,
    "1", "2", "3","4","5","6","7","8","9",        
            
    reset_callback = function(self_points)
       self_points.value = dt.preferences.read("enfuse_pro", "selected_control_points", "integer")
    end
} 



combobox_control_points_remove = dt.new_widget("combobox")
{
    label = _('remove control points with error'), 
    tooltip =_('remove all control points with an error higher \nthan num pixels \ndefault: (3)'),
    value = dt.preferences.read("enfuse_pro", "selected_control_points_remove", "integer"), --3, "1", "2", "3","4","5","6","7","8","9",
    changed_callback = function(sel_control_points_remove) 
    end,
    "1", "2", "3","4","5","6","7","8","9",              
    reset_callback = function(self_points_error)
       self_points_error.value = dt.preferences.read("enfuse_pro", "selected_control_points_remove", "integer")
    end
} 



combobox_correlation  = dt.new_widget("combobox")
{
    label = _('correlation threshold for control points'), 
    tooltip =_('correlation threshold for identifying \ncontrol points \ndefault: (0.9).'),
    value = dt.preferences.read("enfuse_pro", "selected_correlation", "integer"), --9, "0,1", "0,2", "0,3","0,4","0,5","0,6","0,7","0,8","0,9",
    changed_callback = function(sel_correlation) 
    end,
    "0.1", "0.2", "0.3","0.4","0.5","0.6","0.7","0.8","0.9","1.0",  
            
            
    reset_callback = function(self_correlation)
       self_correlation.value = dt.preferences.read("enfuse_pro", "selected_correlation", "integer")
    end
} 



combobox_contrast_window_size = dt.new_widget("combobox")
{
    label = _('contrast window size'), 
    tooltip =_('set the window size for local contrast analysis. \nthe window will be a square of size × size pixels. \nif given an even size, Enfuse will \nautomatically use the next odd number.\nfor contrast analysis size values larger \nthan 5 pixels might result in a \nblurry composite image. values of 3 and \n5 pixels have given good results on \nfocus stacks. \ndefault: (5) pixels'),
    value = dt.preferences.read("enfuse_pro", "selected_contrast_window_size", "integer"), --3, "3","4","5","6","7","8","9","10",
    changed_callback = function(sel_window_size) 
    cmd_enfuse_contrast_window_size="--contrast-window-size="..sel_window_size.value
    end,
    "3", "4", "5","6","7","8","9","10",   
} 



combobox_contrast_edge_scale = dt.new_widget("combobox")
{
    label = _('contrast edge scale'), 
    tooltip =_('a non-zero value for EDGE-SCALE switches on the \nLaplacian-of-Gaussian (LoG) edge detection algorithm.\n edage-scale is the radius of the Gaussian used \nin the search for edges. a positive LCE-SCALE \nturns on local contrast enhancement (LCE) \nbefore the LoG edge detection. \nDefault: (0.0) pixels.'),
    value = dt.preferences.read("enfuse_pro", "selected_contrast_edge_scale", "integer"), --1, "0:0:0",
    changed_callback = function(sel_contrast_edge_scale) 
    cmd_enfuse_contrast_edge_scale="--contrast-edge-scale="..sel_contrast_edge_scale.value
    end,
    "0.0","0.1","0.2","0.3","0.4","0.5",

}  


combobox_contrast_min_curvature = dt.new_widget("combobox")
{
    label = _('contrast min curvature'),
    tooltip =_('define the minimum curvature for the LoG edge detection. Append a ‘%’ to specify the minimum curvature relative to maximum pixel value in the source image. Default: (0.0%)'),
    value = dt.preferences.read("enfuse_pro", "selected_contrast_min_curvature", "integer"), --1, "0.0%","0.1%", "0.2%", "0.3%","0.4%","0.5%","0.6%","0.7%","0.8%","0.9%","1.0%", 
    changed_callback = function(sel_contrast_min_curvature) 
    cmd_enfuse_contrast_min_curvature="--contrast-min-curvature="..sel_contrast_min_curvature.value
    end,
    "0.0%", "0.1%", "0.2%","0.3%","0.4%","0.5%","0.6%","0.7%","0.8%","0.9%","1.0%",   
}  

combobox_existing_file = dt.new_widget("combobox")
{
    label = _('on conflict'), 
    value = dt.preferences.read("enfuse_pro", "selected_overwrite", "integer"), --1, 
    sensitive= dt.preferences.read("enfuse_pro", "sentitiv_overwrite", "bool"), --1, 
    changed_callback = function(sel_overwrite) 
       dt.preferences.write("enfuse_pro", "selected_overwrite", "integer", sel_overwrite.selected)
    end,
    _('create unique filename'),_('overwrite'),           
    reset_callback = function(self_overwrite)
       self_overwrite.value = dt.preferences.read("enfuse_pro", "selected_overwrite", "integer")
    end
}  

check_button_image_variations = dt.new_widget("check_button")
{
    label = _('create image variants with saved presets'), 
    value = dt.preferences.read("enfuse_pro", "checked_image_variants", "bool"),
    tooltip =_('creates image variants with the three \nsaved HDR or DFF presets'),   
    sensitive=true,
    clicked_callback = function(variations) 
    if (variations.value) then
        dt.preferences.write("enfuse_pro", "checked_image_variants", "bool", true)
        dt.preferences.write("enfuse_pro", "sentitiv_overwrite", "bool",false)
        combobox_existing_file.value=1
        combobox_existing_file.sensitive=false
    else  
       dt.preferences.write("enfuse_pro", "checked_image_variants", "bool", false)
       dt.preferences.write("enfuse_pro", "sentitiv_overwrite", "bool",true)
       combobox_existing_file.sensitive=true 
    end    
    
    end,
    reset_callback = function(self_image_variations) 
       dt.preferences.write("enfuse_pro", "checked_image_variants", "bool", false)
       dt.preferences.write("enfuse_pro", "sentitiv_overwrite", "bool",true)
       self_image_variations.value = false
       combobox_existing_file.sensitive=true
    end

}

button_save_preset = dt.new_widget("button")
{
      label = _('save fusion preset'),
      tooltip =_('save the selected fusion preset'),
      clicked_callback = function(save_fusion_type) 
        if (combobox_fusion_type.value == "1 - high dynamic range image") then
      -- preset HDR 1
          dt.preferences.write("enfuse_pro", "checked_hdr1_hard_masks", "bool", check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_hdr1_save_masks", "bool", check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_window_size", "integer", combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_edge_scale", "integer", combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr1_contrast_min_curvature", "integer", combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_hdr1_exposure_weight", "float", slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr1_saturation_weight", "float", slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr1_contrast_weight", "float", slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr1_exposure_optimum_weight", "float", slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr1_exposure_width_weight", "float",slider_exposure_width_weight.value)
          dt.print(_('preset HDR 1 saved')) 
          
          elseif (combobox_fusion_type.value == "2 - high dynamic range image") then
      -- preset HDR 2
          dt.preferences.write("enfuse_pro", "checked_hdr2_hard_masks", "bool", check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_hdr2_save_masks", "bool", check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_window_size", "integer", combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_edge_scale", "integer", combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr2_contrast_min_curvature", "integer", combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_hdr2_exposure_weight", "float", slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr2_saturation_weight", "float", slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr2_contrast_weight", "float", slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr2_exposure_optimum_weight", "float", slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr2_exposure_width_weight", "float",slider_exposure_width_weight.value)
          dt.print(_('preset HDR 2 saved')) 
          
           
          elseif (combobox_fusion_type.value == "3 - high dynamic range image") then
      -- preset HDR 3
          dt.preferences.write("enfuse_pro", "checked_hdr3_hard_masks", "bool", check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_hdr3_save_masks", "bool", check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_window_size", "integer", combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_edge_scale", "integer", combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_hdr3_contrast_min_curvature", "integer", combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_hdr3_exposure_weight", "float", slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr3_saturation_weight", "float", slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr3_contrast_weight", "float", slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr3_exposure_optimum_weight", "float", slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_hdr3_exposure_width_weight", "float",slider_exposure_width_weight.value)
          dt.print(_('preset HDR 3 saved')) 
          
          elseif (combobox_fusion_type.value == "1 - deep focus fusion image") then
      -- preset DFF 1
          dt.preferences.write("enfuse_pro", "checked_dff1_hard_masks", "bool", check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_dff1_save_masks", "bool", check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_dff1_contrast_window_size", "integer", combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_dff1_contrast_edge_scale", "integer", combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_dff1_contrast_min_curvature", "integer", combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_dff1_exposure_weight", "float", slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff1_saturation_weight", "float", slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff1_contrast_weight", "float", slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff1_exposure_optimum_weight", "float", slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff2_exposure_width_weight", "float",slider_exposure_width_weight.value)
          dt.print(_('preset DFF 1 saved')) 
          
          elseif (combobox_fusion_type.value == "2 - deep focus fusion image") then
      -- preset DFF 2
          dt.preferences.write("enfuse_pro", "checked_dff2_hard_masks", "bool", check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_dff2_save_masks", "bool", check_button_save_masks.value)  
          dt.preferences.write("enfuse_pro", "selected_dff2_contrast_window_size", "integer", combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_dff2_contrast_edge_scale", "integer", combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_dff2_contrast_min_curvature", "integer", combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_dff2_exposure_weight", "float", slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff2_saturation_weight", "float", slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff2_contrast_weight", "float", slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff2_exposure_optimum_weight", "float", slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff2_exposure_width_weight", "float",slider_exposure_width_weight.value)
          dt.print(_('preset DFF 2 saved')) 
          
          elseif (combobox_fusion_type.value == "3 - deep focus fusion image") then
      -- preset DFF 3
          dt.preferences.write("enfuse_pro", "checked_dff3_hard_masks", "bool", check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_dff3_save_masks", "bool", check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_dff3_contrast_window_size", "integer", combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_dff3_contrast_edge_scale", "integer", combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_dff3_contrast_min_curvature", "integer", combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_dff3_exposure_weight", "float", slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff3_saturation_weight", "float", slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff3_contrast_weight", "float", slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff3_exposure_optimum_weight", "float", slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_dff3_exposure_width_weight", "float",slider_exposure_width_weight.value)
          dt.print(_('preset DFF 3 saved')) 
          
          elseif (combobox_fusion_type.value == "free preset") then
      -- preset FREE
          dt.preferences.write("enfuse_pro", "checked_free_hard_masks", "bool", check_button_hard_masks.value) 
          dt.preferences.write("enfuse_pro", "checked_free_save_masks", "bool", check_button_save_masks.value) 
          dt.preferences.write("enfuse_pro", "selected_free_contrast_window_size", "integer", combobox_contrast_window_size.selected)
          dt.preferences.write("enfuse_pro", "selected_free_contrast_edge_scale", "integer", combobox_contrast_edge_scale.selected)
          dt.preferences.write("enfuse_pro", "selected_free_contrast_min_curvature", "integer", combobox_contrast_min_curvature.selected) 
          dt.preferences.write("enfuse_pro", "set_free_exposure_weight", "float", slider_exposure_weight.value)
          dt.preferences.write("enfuse_pro", "set_free_saturation_weight", "float", slider_saturation_weight.value)
          dt.preferences.write("enfuse_pro", "set_free_contrast_weight", "float", slider_contrast_weight.value)
          dt.preferences.write("enfuse_pro", "set_free_exposure_optimum_weight", "float", slider_exposure_optimum_weight.value)
          dt.preferences.write("enfuse_pro", "set_free_exposure_width_weight", "float",slider_exposure_width_weight.value)
          dt.print(_('preset free saved')) 
          else
          dt.print(_('unkown error'))
        end
      end
}

button_load_preset = dt.new_widget("button")
{
      label = _('load fusion preset defaults'),
      tooltip =_('load the default fusion preset settings'),
      clicked_callback = function(preset_default) 
        check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_hard_masks", "bool") 
        check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_save_masks", "bool") 
        combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_contrast_window_size", "integer")
        combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_contrast_edge_scale", "integer")
        combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_contrast_min_curvature", "integer")
        slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_exposure_weight", "float")
        slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_saturation_weight", "float")
        slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_contrast_weight", "float")
        slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_exposure_optimum_weight", "float")
        slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_exposure_width_weight", "float")
     end
      
}


combobox_output_format = dt.new_widget("combobox")
{
    label = _('file format'), 
    value = dt.preferences.read("enfuse_pro", "selected_output_format", "integer"), --2, "TIFF", "JPEG", "PNG","PNM","PBM","PGM","PPM",
    changed_callback = function(sel_output_format) 
      dt.preferences.write("enfuse_pro", "selected_output_format", "integer", sel_output_format.selected)
    end,
    "TIFF", "JPEG", "PNG","PNM","PBM","PPM",            
    reset_callback = function(self_output_format)
       self_output_format.value = dt.preferences.read("enfuse_pro", "selected_output_format", "integer")
    end
}  



combobox_fusion_type = dt.new_widget("combobox")
{
    label = _('fusion preset'), 
    tooltip =_('select the preset and save the preset\n if you want to reuse it or create an image\n variant'),
    value = dt.preferences.read("enfuse_pro", "selected_fusion_type", "integer"), --1, "high dynamic range image", "deep focus fusion image", "without preset",
    changed_callback = function(sel_fusion) 
       dt.preferences.write("enfuse_pro", "selected_fusion_type", "integer", sel_fusion.selected)
       -- preset HDR 1
       if (sel_fusion.value == "1 - high dynamic range image") then
        -- defaults for hdr images
        check_button_hard_masks.sensitive=false
        check_button_hard_masks.value=false
        slider_contrast_weight.sensitive=true
        check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr1_hard_masks", "bool") 
        check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr1_save_masks", "bool") 
        combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_hdr1_contrast_window_size", "integer")
        combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_hdr1_contrast_edge_scale", "integer")
        combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_hdr1_contrast_min_curvature", "integer") 
        slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_hdr1_exposure_weight", "float")
        slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_hdr1_saturation_weight", "float")
        slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_hdr1_contrast_weight", "float")
        slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_hdr1_exposure_optimum_weight", "float")
        slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_hdr1_exposure_width_weight", "float")
        
        
        -- preset HDR 2
       elseif (sel_fusion.value == "2 - high dynamic range image") then
        -- defaults for hdr images
        check_button_hard_masks.sensitive=false
        check_button_hard_masks.value=false
        slider_contrast_weight.sensitive=true
        check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr2_hard_masks", "bool") 
        check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr2_save_masks", "bool") 
        combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_hdr2_contrast_window_size", "integer")
        combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_hdr2_contrast_edge_scale", "integer")
        combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_hdr2_contrast_min_curvature", "integer")
        slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_hdr2_exposure_weight", "float")
        slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_hdr2_saturation_weight", "float")
        slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_hdr2_contrast_weight", "float")
        slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_hdr2_exposure_optimum_weight", "float")
        slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_hdr2_exposure_width_weight", "float")
        
         -- preset HDR 3
       elseif (sel_fusion.value == "3 - high dynamic range image") then
        -- defaults for hdr images
        check_button_hard_masks.sensitive=false
        check_button_hard_masks.value=false
        slider_contrast_weight.sensitive=true
        check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr3_hard_masks", "bool") 
        check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_hdr3_save_masks", "bool") 
        combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_hdr3_contrast_window_size", "integer")
        combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_hdr3_contrast_edge_scale", "integer")
        combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_hdr3_contrast_min_curvature", "integer")
        slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_hdr3_exposure_weight", "float")
        slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_hdr3_saturation_weight", "float")
        slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_hdr3_contrast_weight", "float")
        slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_hdr3_exposure_optimum_weight", "float")
        slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_hdr3_exposure_width_weight", "float")
        
       -- preset DFF 1
       elseif (sel_fusion.value == "1 - deep focus fusion image") then
        -- defaults for focus stacking images
        check_button_hard_masks.sensitive=false
        check_button_hard_masks.value=true
        slider_contrast_weight.sensitive=false
        check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_dff1_hard_masks", "bool") 
        check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_dff1_save_masks", "bool") 
        combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_dff1_contrast_window_size", "integer")
        combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_dff1_contrast_edge_scale", "integer")
        combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_dff1_contrast_min_curvature", "integer")  
        slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_dff1_exposure_weight", "float")
        slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_dff1_saturation_weight", "float")
        slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_dff1_contrast_weight", "float")
        slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_dff1_exposure_optimum_weight", "float")
        slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_dff1_exposure_width_weight", "float")
        
        -- preset DFF 2
       elseif (sel_fusion.value == "2 - deep focus fusion image") then
        -- defaults for focus stacking images
        check_button_hard_masks.sensitive=false
        check_button_hard_masks.value=true
        slider_contrast_weight.sensitive=false
        check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_dff2_hard_masks", "bool") 
        check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_dff2_save_masks", "bool") 
        combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_dff2_contrast_window_size", "integer")
        combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_dff2_contrast_edge_scale", "integer")
        combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_dff2_contrast_min_curvature", "integer")  
        slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_dff2_exposure_weight", "float")
        slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_dff2_saturation_weight", "float")
        slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_dff2_contrast_weight", "float")
        slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_dff2_exposure_optimum_weight", "float")
        slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_dff2_exposure_width_weight", "float")
        
        -- preset DFF 3
       elseif (sel_fusion.value == "3 - deep focus fusion image") then
        -- defaults for focus stacking images
        check_button_hard_masks.sensitive=false
        check_button_hard_masks.value=true
        slider_contrast_weight.sensitive=false
        check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_dff3_hard_masks", "bool") 
        check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_dff3_save_masks", "bool") 
        combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_dff3_contrast_window_size", "integer")
        combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_dff3_contrast_edge_scale", "integer")
        combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_dff3_contrast_min_curvature", "integer") 
        slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_dff3_exposure_weight", "float")
        slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_dff3_saturation_weight", "float")
        slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_dff3_contrast_weight", "float")
        slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_dff3_exposure_optimum_weight", "float")
        slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_dff3_exposure_width_weight", "float")
      
       -- preset FREE
       elseif (sel_fusion.value == "free preset") then
        -- enfuse defaults
        check_button_hard_masks.sensitive=true
        check_button_hard_masks.value=false
        slider_contrast_weight.sensitive=true
        check_button_hard_masks.value=dt.preferences.read("enfuse_pro", "checked_free_hard_masks", "bool") 
        check_button_save_masks.value=dt.preferences.read("enfuse_pro", "checked_free_save_masks", "bool") 
        combobox_contrast_window_size.value=dt.preferences.read("enfuse_pro", "selected_free_contrast_window_size", "integer")
        combobox_contrast_edge_scale.value=dt.preferences.read("enfuse_pro", "selected_free_contrast_edge_scale", "integer")
        combobox_contrast_min_curvature.value=dt.preferences.read("enfuse_pro", "selected_free_contrast_min_curvature", "integer")
        slider_exposure_weight.value=dt.preferences.read("enfuse_pro", "set_free_exposure_weight", "float")
        slider_saturation_weight.value=dt.preferences.read("enfuse_pro", "set_free_saturation_weight", "float")
        slider_contrast_weight.value=dt.preferences.read("enfuse_pro", "set_free_contrast_weight", "float")
        slider_exposure_optimum_weight.value=dt.preferences.read("enfuse_pro", "set_free_exposure_optimum_weight", "float")
        slider_exposure_width_weight.value=dt.preferences.read("enfuse_pro", "set_free_exposure_width_weight", "float")
        
      
       end     
    end,
    "1 - high dynamic range image", "2 - high dynamic range image","3 - high dynamic range image","1 - deep focus fusion image", "2 - deep focus fusion image","3 - deep focus fusion image","free preset",  
    
    reset_callback = function(self_type)
       combobox_fusion_type.value = dt.preferences.read("enfuse_pro", "selected_fusion_type", "integer")
    end
} 




--FUNCTION  
  
local widget = dt.new_widget("box") {
    orientation = "vertical",
    label_align_options,
    label_line2,
    check_button_radial_distortion,
    check_button_optimize_field,
    check_button_optimize_image_center,
    check_button_auto_crop,
    check_button_distortion,
    combobox_grid_size,
    combobox_control_points,
    combobox_control_points_remove,
    combobox_correlation,
    separator1,
    separator1b,
    label_enfuse_options,
    label_line3,
    combobox_fusion_type,
    check_button_image_variations,
    slider_exposure_weight,
    slider_saturation_weight,
    slider_contrast_weight,
    slider_exposure_optimum_weight,
    slider_exposure_width_weight, 
    check_button_hard_masks,
    check_button_save_masks,
    combobox_contrast_edge_scale,
    combobox_contrast_min_curvature,
    combobox_contrast_window_size,
    button_save_preset,
    button_load_preset,
    separator2,
    separator2b,
    label_output_format,
    label_line1,
    combobox_output_format,
    label_path,
    file_chooser_button_path,
    combobox_existing_file,
}


local function GetFileName(full_path)
      local filename_with_suffix=full_path:match("[^/]+$" )
      return string.sub(filename_with_suffix,1, -5)
end

local function truncate(x)
      return x<0 and math.ceil(x) or math.floor(x)
end 

local function replace_comma_to_dot(s)
	return string.gsub(s, "%,", ".")
end

local function checkIfBinExists(bin)
  local handle = io.popen("which "..bin)
  local result = handle:read()
  local ret
  handle:close()
  if (result) then
    ret = true
  else
    ret = false
  end


  return ret
end

local function file_exists(name)
   local f=io.open(""..name.."","r")
   if f~=nil then 
       io.close(f) 
       return true 
   else 
       return false 
   end
end


local function remove_temp_files()
    
                    dt.print_error("rm "..images_to_align)
                    result_to_align_images=dt.control.execute("rm "..images_to_align)
                    dt.print_error("rm "..tmppath.."/aligned_*.tif")
                    result_aligned_images=dt.control.execute("rm "..tmppath.."/aligned_*.tif")
                    
end


local function create_enfuse_command()
-- create enfuse command
            enfuseStartCommand="enfuse "..cmd_enfuse_exposure_weight.." "..cmd_enfuse_saturation_weight.." "..cmd_enfuse_contrast_weight.." "..cmd_enfuse_exposure_optimum_weight.." "..cmd_enfuse_exposure_width_weight.." "..cmd_enfuse_hard_masks.." "..cmd_enfuse_save_masks.." "..cmd_enfuse_contrast_window_size.." "..cmd_enfuse_contrast_edge_scale.." "..cmd_enfuse_contrast_min_curvature.." "..cmd_enfuse_color_depth.." "..cmd_enfuse_compression.." "..cmd_output_image.." "..tmppath.."/aligned_*.tif"
            dt.print_error(enfuseStartCommand)
            -- execute enfuse
            resultenfuse=dt.control.execute(enfuseStartCommand)

             job.percent = job.percent + 0.10
            if (resultenfuse == 0) then
                 --copy exif tasgs
                 if (dt.preferences.read("module_enfuse_pro", "exiftool_copy_tags", "bool")) then
                   -- create exif command
                   exixStartCommand="exiftool -TagsFromFile \""..first_imagefile.."\" -exif:all --subifd:all -overwrite_original \""..cmd_output_path.."/"..(GetFileName(first_imagefile)).."-"..(GetFileName(last_imagefile)).."."..cmd_suffix_output_format.."\""
                   dt.print_error(exixStartCommand)
                   -- execute exif
                   resultexif=dt.control.execute(exixStartCommand)
                      if (dt.preferences.read("module_enfuse_pro", "add_image_to_db", "bool")) then
                          local image = dt.database.import(path_with_filename)
                      end
                      dt.print(_('process successfully completed'))
                   if (resultexif == 0) then
                    --   remove_temp_files()
                       dt.print(_('process successfully completed'))
                   else
                     --  remove_temp_files()
                       dt.print(_('ERROR: exiftool doesn\'t work. for more informations see terminal output')) 
                   --    job.valid = false
                   end
                 elseif (dt.preferences.read("module_enfuse_pro", "add_image_to_db", "bool")) then
                        local image = dt.database.import(path_with_filename)
                 end 
            else
              -- remove_temp_files()
               dt.print(_('ERROR: enfuse doesn\'t work. for more informations see terminal output'))
            end   

end


local function show_status(storage, image, format, filename,
  number, total, high_quality, extra_data)
     dt.print(_('export TIFF for image fusion ')..tostring(truncate(number)).." / "..tostring(truncate(total)))   
end

  



local function create_image_fusion(storage, image_table, extra_data) --finalize
job = dt.gui.create_job(_('creating HDR/DFF image'), true, stop_selection)
    -- check installed software
   if (not (checkIfBinExists("align_image_stack"))) then
     dt.print(_('ERROR: align_image_stack not found. please install hugin.'))
     dt.print_error(_('align_image_stack not found. please install hugin.'))
     dt.control.execute("rm "..tmppath.."/*.tif")
     job.valid = false
     return
   elseif  (not (checkIfBinExists("enfuse"))) then
     dt.print(_('ERROR: enfuse not found. please install enfuse.'))
     dt.print_error(_('enfuse not found. please install enfuse.'))
     dt.control.execute("rm "..tmppath.."*.tif")
     job.valid = false
     return
   end 
   enfuseVersionStartCommand='enfuse --version | grep "enfuse 4.2"'
   enfuse_version=dt.control.execute(enfuseVersionStartCommand)
   if (enfuse_version ~= 0) then
       dt.print(_('ERROR: wrong enfuse version found. the plugin works only with enfuse 4.2! please install enfuse version 4.2'))
       job.valid = false
       return
   end
   
 cmd_output_path = file_chooser_button_path.value
if (cmd_output_path == nil) then
     dt.print(_('ERROR: no target directory selected'))  
     job.valid = false
     return
else
   -- create align command
   dt.print(_('aligning images'))
   
   if (check_button_radial_distortion.value) then
   cmd_align_radial_distortion="-d"
   else 
   cmd_align_radial_distortion=""
   end
   
   if (check_button_optimize_field.value) then
   cmd_align_optimize_field="-m"   
   else
   cmd_align_optimize_field=""   
   end
   
   if (check_button_optimize_image_center.value) then
   cmd_align_optimize_center="-i"  
   else
   cmd_align_optimize_center=""    
   end
   
   if (check_button_auto_crop.value) then
   cmd_align_auto_crop="-C"         
   else
   cmd_align_auto_crop=""         
   end

   if (check_button_distortionvalue) then
   cmd_align_distortion="--distortion" 
   else
   cmd_align_distortion=""
   end

   cmd_align_grid_size="-g "..combobox_grid_size.value
   cmd_align_control_points="-c "..combobox_control_points.value           
   cmd_align_control_points_remove="-t "..combobox_control_points_remove.value
   cmd_align_correlation="--corr="..combobox_correlation.value
   if (dt.preferences.read("module_enfuse_pro", "align_use_gpu", "bool")) then
   cmd_align_use_gpu="--gpu"
   else
   cmd_align_use_gpu=""   
   end
   
   images_to_align =""
   local counted_images=0
   for _,v in pairs(image_table) do
                 images_to_align = images_to_align.."\"" ..v.."\" "
                 counted_images=counted_images+1
                 if (counted_images == 1) then
                 first_imagefile=v  
                 else
                 last_imagefile=v    
                 end
                
   end
job.percent = 0.1
   if (counted_images<=1) then
      dt.print(_('ERROR: not enough pictures selected. please select two or more images\nfrom the same object, but with different camera settings.'))
      dt.control.execute("rm "..tmppath.."/*.tif")
      job.valid = false
      return
   elseif (counted_images>=21) then  
      dt.print(_('you have selected more then 20 images. the align and fuse process could take a very long time! \nhave a nice beake.'))
   end    
   
   
    -- execute align_image_stack
   alignStartCommand="align_image_stack " ..cmd_align_radial_distortion.." "..cmd_align_optimize_field.." "..cmd_align_optimize_center.." "..cmd_align_auto_crop.." "..cmd_align_distortion.." "..cmd_align_grid_size.." "..cmd_align_control_points.." "..cmd_align_control_points_remove.." "..cmd_align_correlation.." "..cmd_align_use_gpu.." -a "..tmppath.."/aligned_ "..images_to_align
   
   dt.print_error(alignStartCommand)
   resultalign=dt.control.execute(alignStartCommand)
job.percent = 0.3
   if (resultalign == 0) then
    dt.print(_('aligning complete'))
-- enfuse with all HDR presets
       if (((check_button_image_variations.value) and (combobox_fusion_type.value == "1 - high dynamic range image")) or
           ((check_button_image_variations.value) and (combobox_fusion_type.value == "2 - high dynamic range image")) or
           ((check_button_image_variations.value) and (combobox_fusion_type.value == "3 - high dynamic range image"))) then
           
           
        for i = 1, 3 do
            dt.print(_('fuse image with HDR '..i..' presete'))
            cmd_enfuse_exposure_weight="--exposure-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_hdr"..i.."_exposure_weight", "float")))
            cmd_enfuse_saturation_weight="--saturation-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_hdr"..i.."_saturation_weight", "float")))    
            cmd_enfuse_contrast_weight="--contrast-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_hdr"..i.."_contrast_weight", "float")))
            cmd_enfuse_exposure_optimum_weight="--exposure-optimum="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_hdr"..i.."_exposure_optimum_weight", "float")))
            cmd_enfuse_exposure_width_weight="--exposure-width="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_hdr"..i.."_exposure_width_weight", "float")))
            
            if (check_button_hard_masks.value) then
            cmd_enfuse_hard_masks="--hard-mask"
            else 
            cmd_enfuse_hard_masks=""   
            end
       
            if (check_button_save_masks.value) then
            cmd_enfuse_save_masks="--save-masks"    
            else    
            cmd_enfuse_save_masks=""
            end
            
            cmd_enfuse_contrast_window_size="--contrast-window-size="..dt.preferences.read("enfuse_pro", "selected_hdr"..i.."_contrast_window_size", "integer")
            cmd_enfuse_contrast_edge_scale="--contrast-edge-scale="..dt.preferences.read("enfuse_pro", "selected_hdr"..i.."_contrast_edge_scale", "integer")
            cmd_enfuse_contrast_min_curvature="--contrast-min-curvature="..dt.preferences.read("enfuse_pro", "selected_hdr"..i.."_contrast_min_curvature", "integer") 
            cmd_output_path=file_chooser_button_path.value
            cmd_enfuse_color_depth="--depth="..dt.preferences.read("module_enfuse_pro", "image_color_depth", "enum")   
            
            if (combobox_output_format.value == "TIFF") then
               cmd_suffix_output_format="tif"
            elseif (combobox_output_format.value == "JPEG") then
               cmd_suffix_output_format="jpg"
            elseif (combobox_output_format.value == "PNG") then
               cmd_suffix_output_format="png"
            elseif (combobox_output_format.value == "PNM") then
               cmd_suffix_output_format="pnm"     
            elseif (combobox_output_format.value == "PBM") then
               cmd_suffix_output_format="pbm"   
            elseif (combobox_output_format.value == "PPM") then
               cmd_suffix_output_format="ppm"
            end
                        
            
            if (combobox_output_format.value == "JPEG") then --JPEG
              cmd_enfuse_compression="--compression="..truncate(dt.preferences.read("module_enfuse_pro", "compression_jpeg", "integer"))
            elseif (combobox_output_format.value == "TIFF") then --TIFF
              cmd_enfuse_compression="--compression="..dt.preferences.read("module_enfuse_pro", "compression_tiff", "enum")
            else
             cmd_enfuse_compression=""   
            end
            
            path_with_filename=cmd_output_path.."/"..(GetFileName(first_imagefile)).."-"..(GetFileName(last_imagefile)).."."..cmd_suffix_output_format
                dt.print_error(path_with_filename)
               while (file_exists(path_with_filename)) do
                   cmd_output_image_index=cmd_output_image_index+1
                   if cmd_output_image_index <= 9 then
                   outputindex="0"..tostring(cmd_output_image_index)
                   else
                   outputindex=tostring(cmd_output_image_index)   
                   end
                   
                   path_with_filename=cmd_output_path.."/"..(GetFileName(first_imagefile)).."-"..(GetFileName(last_imagefile)).."_"..outputindex.."."..cmd_suffix_output_format
                  
               end 
               cmd_output_image="--output=\""..path_with_filename.."\""
               cmd_output_image_index=0
            create_enfuse_command()
        end
            remove_temp_files()
            job.valid = false
            dt.print(_('process successfully completed'))
            
           
-- enfuse with all DFF presets 
        elseif (((check_button_image_variations.value) and (combobox_fusion_type.value == "1 - deep focus fusion image")) or
                ((check_button_image_variations.value) and (combobox_fusion_type.value == "2 - deep focus fusion image")) or
                ((check_button_image_variations.value) and (combobox_fusion_type.value == "3 - deep focus fusion image"))) then

          
           
        for i = 1, 3 do
            dt.print(_('fuse image with DFF '..i..' presete')) 
            cmd_enfuse_exposure_weight="--exposure-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_dff"..i.."_exposure_weight", "float")))
            cmd_enfuse_saturation_weight="--saturation-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_dff"..i.."_saturation_weight", "float")))    
            cmd_enfuse_contrast_weight="--contrast-weight="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_dff"..i.."_contrast_weight", "float")))
            cmd_enfuse_exposure_optimum_weight="--exposure-optimum="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_dff"..i.."_exposure_optimum_weight", "float")))
            cmd_enfuse_exposure_width_weight="--exposure-width="..(replace_comma_to_dot(dt.preferences.read("enfuse_pro", "set_dff"..i.."_exposure_width_weight", "float")))
            
            if (check_button_hard_masks.value) then
            cmd_enfuse_hard_masks="--hard-mask"
            else 
            cmd_enfuse_hard_masks=""   
            end
       
            if (check_button_save_masks.value) then
            cmd_enfuse_save_masks="--save-masks"    
            else    
            cmd_enfuse_save_masks=""
            end
            
            
            cmd_enfuse_contrast_window_size="--contrast-window-size="..dt.preferences.read("enfuse_pro", "selected_dff"..i.."_contrast_window_size", "integer")
            cmd_enfuse_contrast_edge_scale="--contrast-edge-scale="..dt.preferences.read("enfuse_pro", "selected_dff"..i.."_contrast_edge_scale", "integer")
            cmd_enfuse_contrast_min_curvature="--contrast-min-curvature="..dt.preferences.read("enfuse_pro", "selected_dff"..i.."_contrast_min_curvature", "integer") 
            cmd_output_path=file_chooser_button_path.value
            cmd_enfuse_color_depth="--depth="..dt.preferences.read("module_enfuse_pro", "image_color_depth", "enum")   
            
                       
            if (combobox_output_format.value == "TIFF") then
               cmd_suffix_output_format="tif"
            elseif (combobox_output_format.value == "JPEG") then
               cmd_suffix_output_format="jpg"
            elseif (combobox_output_format.value == "PNG") then
               cmd_suffix_output_format="png"
            elseif (combobox_output_format.value == "PNM") then
               cmd_suffix_output_format="pnm"     
            elseif (combobox_output_format.value == "PBM") then
               cmd_suffix_output_format="pbm"   
            elseif (combobox_output_format.value == "PPM") then
               cmd_suffix_output_format="ppm"
            end
            
            
            if (combobox_output_format.value == "JPEG") then --JPEG
              cmd_enfuse_compression="--compression="..truncate(dt.preferences.read("module_enfuse_pro", "compression_jpeg", "integer"))
            elseif (combobox_output_format.value == "TIFF") then --TIFF
              cmd_enfuse_compression="--compression="..dt.preferences.read("module_enfuse_pro", "compression_tiff", "enum")
            else
             cmd_enfuse_compression=""   
            end
            
            path_with_filename=cmd_output_path.."/"..(GetFileName(first_imagefile)).."-"..(GetFileName(last_imagefile)).."."..cmd_suffix_output_format
                dt.print_error(path_with_filename)
               while (file_exists(path_with_filename)) do
                   cmd_output_image_index=cmd_output_image_index+1
                   if cmd_output_image_index <= 9 then
                   outputindex="0"..tostring(cmd_output_image_index)
                   else
                   outputindex=tostring(cmd_output_image_index)   
                   end
                   
                   path_with_filename=cmd_output_path.."/"..(GetFileName(first_imagefile)).."-"..(GetFileName(last_imagefile)).."_"..outputindex.."."..cmd_suffix_output_format
                  
               end 
               cmd_output_image="--output=\""..path_with_filename.."\""
               cmd_output_image_index=0
            create_enfuse_command()
            job.valid = false
        end
            remove_temp_files()
            dt.print(_('process successfully completed'))
           
-- enfuse with GUI settings          
        else
            if (combobox_fusion_type.value == "1 - high dynamic range image") then
               dt.print(_('enfuse with value from preset HDR 1')) 
            elseif (combobox_fusion_type.value == "2 - high dynamic range image") then
               dt.print(_('enfuse with value from preset HDR 2')) 
            elseif (combobox_fusion_type.value == "3 - high dynamic range image") then
               dt.print(_('enfuse with value from preset HDR 3')) 
            elseif (combobox_fusion_type.value == "1 - deep focus fusion image") then
               dt.print(_('enfuse with value from preset DFF 1')) 
            elseif (combobox_fusion_type.value == "2 - deep focus fusion image") then
               dt.print(_('enfuse with value from preset DFF 2'))
            elseif (combobox_fusion_type.value == "3 - deep focus fusion image") then
               dt.print(_('enfuse with value from preset DFF 3'))
            elseif (combobox_fusion_type.value == "free preset") then
               dt.print(_('enfuse with value from free preset'))
            end
       
            cmd_enfuse_exposure_weight="--exposure-weight="..(replace_comma_to_dot(slider_exposure_weight.value))
            cmd_enfuse_saturation_weight="--saturation-weight="..(replace_comma_to_dot(slider_saturation_weight.value))              
            cmd_enfuse_contrast_weight="--contrast-weight="..(replace_comma_to_dot(slider_contrast_weight.value))
            cmd_enfuse_exposure_optimum_weight="--exposure-optimum="..(replace_comma_to_dot(slider_exposure_optimum_weight.value))
            cmd_enfuse_exposure_width_weight="--exposure-width="..(replace_comma_to_dot(slider_exposure_width_weight.value))
       
            if (check_button_hard_masks.value) then
            cmd_enfuse_hard_masks="--hard-mask"
            else 
            cmd_enfuse_hard_masks=""   
            end
       
            if (check_button_save_masks.value) then
            cmd_enfuse_save_masks="--save-masks"    
            else    
            cmd_enfuse_save_masks=""
            end
       
            cmd_enfuse_contrast_window_size="--contrast-window-size="..combobox_contrast_window_size.value
            cmd_enfuse_contrast_edge_scale="--contrast-edge-scale="..combobox_contrast_edge_scale.value
            cmd_enfuse_contrast_min_curvature="--contrast-min-curvature="..combobox_contrast_min_curvature.value
            
            cmd_output_path=file_chooser_button_path.value
            cmd_enfuse_color_depth="--depth="..dt.preferences.read("module_enfuse_pro", "image_color_depth", "enum")
            
            if (combobox_output_format.value == "TIFF") then
               cmd_suffix_output_format="tif"
            elseif (combobox_output_format.value == "JPEG") then
               cmd_suffix_output_format="jpg"
            elseif (combobox_output_format.value == "PNG") then
               cmd_suffix_output_format="png"
            elseif (combobox_output_format.value == "PNM") then
               cmd_suffix_output_format="pnm"     
            elseif (combobox_output_format.value == "PBM") then
               cmd_suffix_output_format="pbm"   
            elseif (combobox_output_format.value == "PPM") then
               cmd_suffix_output_format="ppm"
            end
            
            
            if (combobox_output_format.value == "JPEG") then --JPEG
              cmd_enfuse_compression="--compression="..truncate(dt.preferences.read("module_enfuse_pro", "compression_jpeg", "integer"))
            elseif (combobox_output_format.value == "TIFF") then --TIFF
              cmd_enfuse_compression="--compression="..dt.preferences.read("module_enfuse_pro", "compression_tiff", "enum")
            else
             cmd_enfuse_compression=""   
            end

            
            if (combobox_existing_file.selected == 1) then
                path_with_filename=cmd_output_path.."/"..(GetFileName(first_imagefile)).."-"..(GetFileName(last_imagefile)).."."..cmd_suffix_output_format
                dt.print_error("Datei mit Pfad")
                dt.print_error(path_with_filename)
               while (file_exists(path_with_filename)) do
                   cmd_output_image_index=cmd_output_image_index+1
                   if cmd_output_image_index <= 9 then
                   outputindex="0"..tostring(cmd_output_image_index)
                   else
                   outputindex=tostring(cmd_output_image_index)   
                   end
                   
                   path_with_filename=cmd_output_path.."/"..(GetFileName(first_imagefile)).."-"..(GetFileName(last_imagefile)).."_"..outputindex.."."..cmd_suffix_output_format
                  
               end 
               cmd_output_image="--output=\""..path_with_filename.."\""
               cmd_output_image_index=0
            else
                cmd_output_image="--output=\""..cmd_output_path.."/"..(GetFileName(first_imagefile)).."-"..(GetFileName(last_imagefile)).."."..cmd_suffix_output_format.."\""
            end
            dt.print_error(path_with_filename)
            create_enfuse_command()
            remove_temp_files()
            job.valid = false
       end
   else
      remove_temp_files() 
    dt.print(_('ERROR: align_image_stack doesn\'t work. For more information see terminal output'))
    job.valid = false
   end
   
end    
end


-- limit export to tiff
local function support_format(storage, format)
  fmt = string.lower(format.name)
  if string.match(fmt,"tiff") == nil then
    return false
  else
    return true
  end   
end  



-- REGISTER
dt.register_storage("module_enfuse_pro", _('pseudo hdr or dff image'), show_status, create_image_fusion, support_format, nil, widget)

dt.preferences.register("module_enfuse_pro",        
                        "align_use_gpu",                                          -- name
                        "bool",                                                   -- type
                        _('enfuse pro: use GPU for remaping'),                       -- label
                        _('set the GPU remapping for image align'),                  -- tooltip
                        false)                                                    -- default
                        
dt.preferences.register("module_enfuse_pro",        
                        "exiftool_copy_tags",                                     -- name
                        "bool",                                                   -- type
                        _('enfuse pro: copy exif tags'),                             -- label
                        _('copy the exif tags from the first image to the target'),  -- tooltip
                        true)                                                     -- default                        

dt.preferences.register("module_enfuse_pro",        
                        "add_image_to_db",                                        -- name
                        "bool",                                                   -- type
                        _('enfuse pro: add fused image to database'),                -- label
                        _('add the fused image to the darktable database'),          -- tooltip
                        false)                                                    -- default           
                        
                        
dt.preferences.register("module_enfuse_pro",        
                        "compression_jpeg",                        -- name
                        "integer",                                 -- type
                        _('enfuse pro: JPEG compression'),            -- label
                        _('set the compression for JPEG files'),      -- tooltip
                        98,                                        -- default
                        50,                                        -- min
                        100)                                       -- max
                        
dt.preferences.register("module_enfuse_pro",        
                        "compression_tiff",                        -- name
                        "enum",                                    -- type
                        _('enfuse pro: TIFF compression'),            -- label
                        _('set the compression type for tiff files'), -- tooltip
                        "LZW",                                     -- default
                        "NONE", "DEFLATE","LZW","PACKBITS")        -- values

                        
dt.preferences.register("module_enfuse_pro",        
                        "image_color_depth",                       -- name
                        "enum",                                    -- type
                        _('enfuse pro: image color depth (bit)'),     -- label
                        _('set the output color depth'),              -- tooltip
                        "16",                                      -- default
                        "8", "16","32","r32","r64")                -- values
                        