--[[
    
    database_statistics.lua - Shows a darktable database statistic

    Copyright (C) 2016 Holger Klemm <http://www.multimedia4linux.de>.
    
    darktable is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    darktable is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with darktable.  If not, see <http://www.gnu.org/licenses/>.
]]
--[[
VERSION 2.1.1
Works with darktable 2.0.X and 2.2.X
   
ADDITIONAL SOFTWARE NEEDED FOR THIS SCRIPT
    * sqlite3
    * rm
    * grep
    * wc
    * du

   USAGE
* require this script from your main lua file

* release notes
   - rewritten code (faster and better)
   
* it creates a new database statistcs module

]]


local dt = require "darktable"
local gettext = dt.gettext
dt.configuration.check_version(...,{3,0,0},{4,0,0})

-- command variables
database_statistics_homepath=os.getenv("HOME")
database_statistics_tmppath=database_statistics_homepath.."/.local/tmp"

local count_discusage = "-"
local count_filmrolls = "-"
local count_images = "-"
local count_rating_0 = "-"
local count_rating_1 = "-"
local count_rating_2 = "-"
local count_rating_3 = "-"
local count_rating_4 = "-"
local count_rating_5 = "-"
local count_red = "-"
local count_yellow = "-"
local count_green = "-"
local count_blue = "-"
local count_magenta = "-"
local count_without = "-"

-- Tell gettext where to find the .mo file translating messages for a particular domain
gettext.bindtextdomain("database_statistics",dt.configuration.config_dir.."/lua/")

local function _(msgid)
    return gettext.dgettext("database_statistics", msgid)
end

database_statistics_labeldiscusage = dt.new_widget("label")
{
     label = _('disc usage:\t\t\t\t') .. count_discusage,
     ellipsize = "start",
     halign = "start"
}

database_statistics_labelfilmrolls = dt.new_widget("label")
{
     label = _('filmrolls:\t\t\t\t\t') .. count_filmrolls,
     ellipsize = "start",
     halign = "start"
}


database_statistics_labelimages = dt.new_widget("label")
{
      label = _('images:\t\t\t\t\t') .. count_images,
      ellipsize = "start",
      halign = "start",
}

local database_statistics_separator_1 = dt.new_widget("separator")
{}


database_statistics_rating_1_label = dt.new_widget("label")
{ 
      label = _('images with 1 star:\t\t\t') .. count_rating_1,
      ellipsize = "start",
      halign = "start",
}

database_statistics_rating_2_label = dt.new_widget("label")
{ 
      label = _('images with 2 stars:\t\t\t') .. count_rating_2,
      ellipsize = "start",
      halign = "start",
}

database_statistics_rating_3_label = dt.new_widget("label")
{ 
      label = _('images with 3 stars:\t\t\t') .. count_rating_3,
      ellipsize = "start",
      halign = "start",
}

database_statistics_rating_4_label = dt.new_widget("label")
{ 
      label = _('images with 4 stars:\t\t\t') .. count_rating_4,
      ellipsize = "start",
      halign = "start",
}

database_statistics_rating_5_label = dt.new_widget("label")
{ 
      label = _('images with 5 stars:\t\t\t') .. count_rating_5,
      ellipsize = "start",
      halign = "start",
}

database_statistics_rating_0_label = dt.new_widget("label")
{ 
      label = _('images without stars:\t\t') .. count_rating_0,
      ellipsize = "start",
      halign = "start",
}

local database_statistics_separator_2 = dt.new_widget("separator")
{}


database_statistics_colorlabelred = dt.new_widget("label")
{ 
      label = _('images with red labels:\t\t') .. count_red,
      ellipsize = "start",
      halign = "start",
}

database_statistics_colorlabelyellow = dt.new_widget("label")
{
      label = _('images with yellow labels:\t\t') .. count_yellow,
      ellipsize = "start",
      halign = "start",
}


database_statistics_colorlabelgreen = dt.new_widget("label")
{
      label = _('images with green labels:\t\t')  .. count_green,
      ellipsize = "start",
      halign = "start",
}

database_statistics_colorlabelblue = dt.new_widget("label")
{
      label = _('images with blue labels:\t\t') .. count_blue,
      ellipsize = "start",
      halign = "start",
}


database_statistics_colorlabelmag = dt.new_widget("label")
{
      label = _('images with magenta labels:\t') .. count_magenta,
      ellipsize = "start",
      halign = "start",
}

database_statistics_nocolorlabels = dt.new_widget("label")
{
      label = _('images without labels:\t\t') .. count_without,
      ellipsize = "start",
      halign = "start",
}


local function checkIfBinExists(bin)
  local handle = io.popen("which "..bin)
  local result = handle:read()
  local ret
  handle:close()
  if (result) then
    ret = true
  else
    dt.print_error(bin.." not found")
    ret = false
  end
  return ret
end

local function checkIfDirExists(path)
    local dir_found =dt.control.execute("ls "..path)
    if (dir_found == 0) then
       return true
    else
       return false
    end
    
end

   
function is_dir(path)
    local f = io.open(path, "r")
    local ok, err, code = f:read(1)
    f:close()
    return code == 21
end

function round(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end


local database_statistics_button = dt.new_widget("button")
{
      label = _('analyse database'),
      clicked_callback = function(xxx) 
database_statistics_job = dt.gui.create_job(_('analyzing database'), true, stop_selection)

      
-- Check installed software    
  if (not (checkIfBinExists("sqlite3"))) then
    dt.print(_("ERROR: sqlite3 not found! please install sqlite3."))
    return
  elseif (not (checkIfBinExists("rm"))) then
    dt.print(_("ERROR: rm not found! please install core utilities."))
    return
  elseif (not (checkIfBinExists("grep"))) then
    dt.print(_("ERROR: grep not found! please install core utilities."))
    return
  elseif (not (checkIfBinExists("wc"))) then
    dt.print(_("ERROR: wc not found! please install core utilities."))
    return
  elseif (not (checkIfBinExists("du"))) then
    dt.print(_("ERROR: du not found! please install core utilities."))
    return
  else  
    dt.print(_('analyze database. please wait...'))
  end


-- Analyse xmp files    
    local counter=0
    local cmd_sqlite3_filmrolls="sqlite3 ~/.config/darktable/library.db \"SELECT COUNT (*) FROM (SELECT DISTINCT folder FROM film_rolls)\";"
    local handle = io.popen(cmd_sqlite3_filmrolls)
    local count_filmrolls = handle:read("*a")
    handle:close()
    number_filmrolls = tonumber(count_filmrolls)
    
    local totaldiscusage=0
    local discusage=0
    local rating0=0
    local rating1=0
    local rating2=0
    local rating3=0
    local rating4=0
    local rating5=0
    local totalrating0=0
    local totalrating1=0
    local totalrating2=0
    local totalrating3=0
    local totalrating4=0
    local totalrating5=0
    
    
-- Calculate Rating
    while counter ~= number_filmrolls do
-- Input dir
        local cmd_sqlite3_InputDir = "sqlite3 ~/.config/darktable/library.db \"SELECT folder FROM film_rolls LIMIT "..counter..",1\";"
        local handle = io.popen(cmd_sqlite3_InputDir)
        local xinputdir = handle:read("*a")
        handle:close()
        inputdir=string.gsub(xinputdir,"\n","")
        inputdir="\""..inputdir.."\""
-- Check Inputdir  

       if (checkIfDirExists(inputdir) == false) then
          dt.print(_('ERROR: directory not found or no read access. please check your database and directory.\n')..xinputdir)
          dt.print_error("directory not found "..xinputdir)
          database_statistics_job.valid = false 
          return
       end
        
-- Disc usage
        local cmd_du = "du -s " ..inputdir.." | cut -f1"
        local handle = io.popen(cmd_du)
        local input_discusage = handle:read("*a")
        handle:close()
        discusage = tonumber(input_discusage)
        totaldiscusage=totaldiscusage + discusage
        
-- Rating 0    
        local cmd_Rating_0 ="grep -r -i \'Rating=\"0\"\' " ..inputdir.."/*.xmp | wc -l"
        local handle0 = io.popen(cmd_Rating_0)
        local input_rating0 = handle0:read("*a")
        handle0:close()
        rating0 = tonumber(input_rating0)
        totalrating0=totalrating0 + rating0

-- Rating 1  
        local cmd_Rating_1 ="grep -r -i \'Rating=\"1\"\' " ..inputdir.."/*.xmp | wc -l"
        local handle1 = io.popen(cmd_Rating_1)
        local input_rating1 = handle1:read("*a")
        handle1:close()
        rating1 = tonumber(input_rating1)
        totalrating1=totalrating1 + rating1

-- Rating 2  
        local cmd_Rating_2 ="grep -r -i \'Rating=\"2\"\' " ..inputdir.."/*.xmp | wc -l"
        local handle2 = io.popen(cmd_Rating_2)
        local input_rating2 = handle2:read("*a")
        handle2:close()
        rating2 = tonumber(input_rating2)
        totalrating2=totalrating2 + rating2
 -- Rating 3  
        local cmd_Rating_3 ="grep -r -i \'Rating=\"3\"\' " ..inputdir.."/*.xmp | wc -l"
        local handle3 = io.popen(cmd_Rating_3)
        local input_rating3 = handle3:read("*a")
        handle3:close()
        rating3 = tonumber(input_rating3)
        totalrating3=totalrating3 + rating3
 -- Rating 4  
        local cmd_Rating_4 ="grep -r -i \'Rating=\"4\"\' " ..inputdir.."/*.xmp | wc -l"
        local handle4 = io.popen(cmd_Rating_4)
        local input_rating4 = handle4:read("*a")
        handle4:close()
        rating4 = tonumber(input_rating4)
        totalrating4=totalrating4 + rating4
  -- Rating 5  
        local cmd_Rating_5 ="grep -r -i \'Rating=\"5\"\' " ..inputdir.."/*.xmp | wc -l"
        local handle5 = io.popen(cmd_Rating_5)
        local input_rating5 = handle5:read("*a")
        handle5:close()
        rating5 = tonumber(input_rating5)
        totalrating5=totalrating5 + rating5
  -- Rating End      
        
        
        
        counter = counter + 1
        xxx=round((100 / number_filmrolls * counter),0)
        finishedstr=tostring(xxx)
        database_statistics_job.percent = xxx/100
    end    
-- Disc usage
        local totaldiscusage_gib = round((totaldiscusage / 1048576),1)
-- Convert to string    
        count_discusage = tostring(totaldiscusage_gib)
        count_rating_0 = tostring(totalrating0) 
        count_rating_1 = tostring(totalrating1) 
        count_rating_2 = tostring(totalrating2) 
        count_rating_3 = tostring(totalrating3) 
        count_rating_4 = tostring(totalrating4) 
        count_rating_5 = tostring(totalrating5)
    
    
-- Export database information
    count_filmrolls=string.gsub(count_filmrolls,"\n","")

    local cmd_sqlite3_images="sqlite3 ~/.config/darktable/library.db  \"SELECT COUNT (*) FROM (SELECT DISTINCT id FROM images)\";"
    local handle_images = io.popen(cmd_sqlite3_images)
    local count_images = handle_images:read("*a")
    handle_images:close()
    count_images=string.gsub(count_images,"\n","")

    local cmd_sqlite3_labelred="sqlite3 ~/.config/darktable/library.db \"SELECT COUNT (*) FROM color_labels WHERE COLOR = 0\";"
    local handle_red = io.popen(cmd_sqlite3_labelred)
    local count_red = handle_red:read("*a")
    count_red=string.gsub(count_red,"\n","")
    
    local cmd_sqlite3_labelyellow="sqlite3 ~/.config/darktable/library.db \"SELECT COUNT (*) FROM color_labels WHERE COLOR = 1\";"
    local handle_yellow = io.popen(cmd_sqlite3_labelyellow)
    local count_yellow = handle_yellow:read("*a")
    count_yellow=string.gsub(count_yellow,"\n","")
    
    local cmd_sqlite3_labelgreen="sqlite3 ~/.config/darktable/library.db \"SELECT COUNT (*) FROM color_labels WHERE COLOR = 2\";"
    local handle_green = io.popen(cmd_sqlite3_labelgreen)
    local count_green = handle_green:read("*a")
    count_green=string.gsub(count_green,"\n","")
    
    local cmd_sqlite3_labelblue="sqlite3 ~/.config/darktable/library.db \"SELECT COUNT (*) FROM color_labels WHERE COLOR = 3\";"
    local handle_blue = io.popen(cmd_sqlite3_labelblue)
    local count_blue = handle_blue:read("*a")
    count_blue=string.gsub(count_blue,"\n","")
    
    local cmd_sqlite3_labelmagenta="sqlite3 ~/.config/darktable/library.db \"SELECT COUNT (*) FROM color_labels WHERE COLOR = 4\";"
    local handle_magenta = io.popen(cmd_sqlite3_labelmagenta)
    local count_magenta = handle_magenta:read("*a")
    count_magenta=string.gsub(count_magenta,"\n","")
    

    
    count_without = count_images - count_red - count_yellow - count_green - count_blue - count_magenta
    
    database_statistics_labeldiscusage.label = _('disc usage:\t\t\t\t') .. count_discusage.. " GiB"
    database_statistics_labelfilmrolls.label = _('filmrolls:\t\t\t\t\t') .. count_filmrolls
    database_statistics_labelimages.label = _('images:\t\t\t\t\t') .. count_images
    database_statistics_rating_0_label.label = _('images without stars:\t\t') .. count_rating_0
    database_statistics_rating_1_label.label = _('images with 1 star:\t\t\t') .. count_rating_1  
    database_statistics_rating_2_label.label = _('images with 2 stars:\t\t\t') .. count_rating_2
    database_statistics_rating_3_label.label = _('images with 3 stars:\t\t\t') .. count_rating_3
    database_statistics_rating_4_label.label = _('images with 4 stars:\t\t\t') .. count_rating_4
    database_statistics_rating_5_label.label = _('images with 5 stars:\t\t\t') .. count_rating_5
    database_statistics_colorlabelred.label = _('images with red labels:\t\t') .. count_red
    database_statistics_colorlabelyellow.label = _('images with yellow labels:\t\t') .. count_yellow
    database_statistics_colorlabelgreen.label = _('images with green labels:\t\t')  .. count_green
    database_statistics_colorlabelblue.label = _('images with blue labels:\t\t') .. count_blue
    database_statistics_colorlabelmag.label = _('images with magenta labels:\t') .. count_magenta
    database_statistics_nocolorlabels.label = _('images without labels:\t\t') .. count_without
    dt.print(_('analyse finished')) 
    database_statistics_job.valid = false 
end      
}



    
    


dt.register_lib(
  "database",     -- Module name
  (_('database statistics')),     -- name
  true,                -- expandable
  false,               -- resetable
  {[dt.gui.views.lighttable] = {"DT_UI_CONTAINER_PANEL_LEFT_CENTER", 100}},   -- containers
  dt.new_widget("box") -- widget
  {
    database_statistics_labeldiscusage,
    database_statistics_labelfilmrolls,
    database_statistics_labelimages,
    database_statistics_separator_1,
    database_statistics_rating_1_label,
    database_statistics_rating_2_label,
    database_statistics_rating_3_label,
    database_statistics_rating_4_label,
    database_statistics_rating_5_label,
    database_statistics_rating_0_label,
    database_statistics_separator_2,
    database_statistics_colorlabelred,
    database_statistics_colorlabelyellow,
    database_statistics_colorlabelgreen,
    database_statistics_colorlabelblue,
    database_statistics_colorlabelmag,
    database_statistics_nocolorlabels,
    database_statistics_button,
  },
  nil,-- view_enter
  nil -- view_leave
)

-- vim: shiftwidth=2 expandtab tabstop=2 cindent syntax=lua
-- kate: hl Lua;
